/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.meta;

/**
 * カラムの型の情報です。
 * @author nakamura
 *
 */
public class ColumnInfo {
	private int dataType;
	private String typeName;
	private int size;
	private int decimalDigits;
	private boolean notNull;
	
	public ColumnInfo(
			final int dataType,
			final String typeName,
			final int size,
			final int decimalDigits,
			final boolean notNull) {
		this.dataType = dataType;
		this.typeName = typeName;
		this.size = size;
		this.decimalDigits = decimalDigits;
		this.notNull = notNull;
	}
	
	public ColumnInfo(){
	}
	
	public boolean isNotNull() {
		return notNull;
	}
	public void setNotNull(final boolean notNull) {
		this.notNull = notNull;
	}
	public int getSize() {
		return size;
	}
	public void setSize(final int size) {
		this.size = size;
	}
	public int getDataType() {
		return dataType;
	}
	public void setDataType(final int dataType) {
		this.dataType = dataType;
	}
	public int getDecimalDigits() {
		return decimalDigits;
	}
	public void setDecimalDigits(final int decimalDigits) {
		this.decimalDigits = decimalDigits;
	}
	public String getTypeName() {
		return typeName;
	}
	public void setTypeName(final String typeName) {
		this.typeName = typeName;
	}
}
