/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.convert;

import java.util.Comparator;

/**
 * パラメータのバインド情報です。
 * <br/>適用しているデザインパターン：変数を格納する構造体。
 * @author nakamura
 *
 */
public class ParamBindInfo {
	/**
	 * {@link #getStart()}による{@link Comparator}です。
	 * {@link ParamBindInfo}の一覧をSQL上の出現順に並べ替える際に利用します。
	 */
	public static final Comparator<ParamBindInfo> COMPARATOR = new Comparator<ParamBindInfo>() {
		public int compare(final ParamBindInfo o1, final ParamBindInfo o2) {
			return o1.start - o2.start;
		}
	};
	
	private String name;
	private int start;
	private int end;
	private String bindString;
	private SqlOperator operator;
	private boolean whereFlag;
	
	public ParamBindInfo(
			final String name,
			final int start,
			final int end,
			final String bindString,
			final SqlOperator operator,
			final boolean whereFlag) {
		this.name = name;
		this.bindString = bindString;
		this.operator = operator;
		this.start = start;
		this.end = end;
		this.whereFlag = whereFlag;
	}
	
	public ParamBindInfo(final String name) {
		this(name, -1, -1, null, null, false);
	}

	public String getName() {
		return name;
	}
	public void setName(final String name) {
		this.name = name;
	}
	public SqlOperator getOperator() {
		return operator;
	}
	public void setOperator(final SqlOperator operator) {
		this.operator = operator;
	}
	public int getStart() {
		return start;
	}
	public void setStart(final int index) {
		this.start = index;
	}
	public boolean isWhereFlag() {
		return whereFlag;
	}
	public void setWhereFlag(final boolean whereFlag) {
		this.whereFlag = whereFlag;
	}
	public String getBindString() {
		return bindString;
	}
	public void setBindString(final String bindString) {
		this.bindString = bindString;
	}
	public int getEnd() {
		return end;
	}
	public void setEnd(final int end) {
		this.end = end;
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((bindString == null) ? 0 : bindString.hashCode());
		result = PRIME * result + end;
		result = PRIME * result + ((name == null) ? 0 : name.hashCode());
		result = PRIME * result + ((operator == null) ? 0 : operator.hashCode());
		result = PRIME * result + start;
		result = PRIME * result + (whereFlag ? 1231 : 1237);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final ParamBindInfo other = (ParamBindInfo) obj;
		if (bindString == null) {
			if (other.bindString != null)
				return false;
		} else if (!bindString.equals(other.bindString))
			return false;
		if (end != other.end)
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (operator == null) {
			if (other.operator != null)
				return false;
		} else if (!operator.equals(other.operator))
			return false;
		if (start != other.start)
			return false;
		if (whereFlag != other.whereFlag)
			return false;
		return true;
	}
}
