/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.adapter;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

/**
 * 委譲するだけの{@link Statement}です。
 * <br/>適用しているデザインパターン：Delegation。
 * @author nakamura
 *
 */
public class StatementAdapter implements Statement {
	private Statement parent;
	
	public StatementAdapter(final Statement parent) {
		this.parent = parent;
	}
	public Statement getParent() {
		return parent;
	}
	public void setParent(final Statement parent) {
		this.parent = parent;
	}

	public void addBatch(final String sql) throws SQLException {
		parent.addBatch(sql);
	}

	public void cancel() throws SQLException {
		parent.cancel();
	}

	public void clearBatch() throws SQLException {
		parent.clearBatch();
	}

	public void clearWarnings() throws SQLException {
		parent.clearWarnings();
	}

	public void close() throws SQLException {
		parent.close();
	}

	public boolean execute(final String sql, final int autoGeneratedKeys) throws SQLException {
		return parent.execute(sql, autoGeneratedKeys);
	}

	public boolean execute(final String sql, final int[] columnIndexes) throws SQLException {
		return parent.execute(sql, columnIndexes);
	}

	public boolean execute(final String sql, final String[] columnNames) throws SQLException {
		return parent.execute(sql, columnNames);
	}

	public boolean execute(final String sql) throws SQLException {
		return parent.execute(sql);
	}

	public int[] executeBatch() throws SQLException {
		return parent.executeBatch();
	}

	public ResultSet executeQuery(final String sql) throws SQLException {
		return parent.executeQuery(sql);
	}

	public int executeUpdate(final String sql, final int autoGeneratedKeys) throws SQLException {
		return parent.executeUpdate(sql, autoGeneratedKeys);
	}

	public int executeUpdate(final String sql, final int[] columnIndexes) throws SQLException {
		return parent.executeUpdate(sql, columnIndexes);
	}

	public int executeUpdate(final String sql, final String[] columnNames) throws SQLException {
		return parent.executeUpdate(sql, columnNames);
	}

	public int executeUpdate(final String sql) throws SQLException {
		return parent.executeUpdate(sql);
	}

	public Connection getConnection() throws SQLException {
		return parent.getConnection();
	}

	public int getFetchDirection() throws SQLException {
		return parent.getFetchDirection();
	}

	public int getFetchSize() throws SQLException {
		return parent.getFetchSize();
	}

	public ResultSet getGeneratedKeys() throws SQLException {
		return parent.getGeneratedKeys();
	}

	public int getMaxFieldSize() throws SQLException {
		return parent.getMaxFieldSize();
	}

	public int getMaxRows() throws SQLException {
		return parent.getMaxRows();
	}

	public boolean getMoreResults() throws SQLException {
		return parent.getMoreResults();
	}

	public boolean getMoreResults(final int current) throws SQLException {
		return parent.getMoreResults(current);
	}

	public int getQueryTimeout() throws SQLException {
		return parent.getQueryTimeout();
	}

	public ResultSet getResultSet() throws SQLException {
		return parent.getResultSet();
	}

	public int getResultSetConcurrency() throws SQLException {
		return parent.getResultSetConcurrency();
	}

	public int getResultSetHoldability() throws SQLException {
		return parent.getResultSetHoldability();
	}

	public int getResultSetType() throws SQLException {
		return parent.getResultSetType();
	}

	public int getUpdateCount() throws SQLException {
		return parent.getUpdateCount();
	}

	public SQLWarning getWarnings() throws SQLException {
		return parent.getWarnings();
	}

	public void setCursorName(final String name) throws SQLException {
		parent.setCursorName(name);
	}

	public void setEscapeProcessing(final boolean enable) throws SQLException {
		parent.setEscapeProcessing(enable);
	}

	public void setFetchDirection(final int direction) throws SQLException {
		parent.setFetchDirection(direction);
	}

	public void setFetchSize(final int rows) throws SQLException {
		parent.setFetchSize(rows);
	}

	public void setMaxFieldSize(final int max) throws SQLException {
		parent.setMaxFieldSize(max);
	}

	public void setMaxRows(final int max) throws SQLException {
		parent.setMaxRows(max);
	}

	public void setQueryTimeout(final int seconds) throws SQLException {
		parent.setQueryTimeout(seconds);
	}

}
