/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import java.util.Map;

import org.w3c.dom.Node;

import woolpack.el.GettingEL;
import woolpack.fn.Fn;
import woolpack.utils.Utils;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

public class SelectedValueUpdater<E extends Exception> implements Fn<NodeContext, Void, E> {
	private GettingEL valueEL;
	private GettingEL mapEL;

	public SelectedValueUpdater(
			final GettingEL valueEL,
			final GettingEL mapEL) {
		this.valueEL = valueEL;
		this.mapEL = mapEL;
	}

	public Void exec(final NodeContext context) {
		final Object value1 = valueEL.getValue(context);
		final Iterable<?> iterable = Utils.toIterable(value1);
		for (final Object value : iterable) {
			if (value == null) {
				continue;
			}
			final String valueString = value.toString();

			final Node newNode = context.getNode().cloneNode(true);
			XmlUtils.removeChildren(newNode);
			try {
				final Map map = (Map) mapEL.getValue(context);
				if (map.containsKey(valueString)) {
					XmlUtils.appendText(newNode, map.get(valueString).toString());
				}
			} catch (final NullPointerException e) {
				XmlUtils.appendText(newNode, valueString);
			}
			context.getNode().getParentNode().insertBefore(newNode,
					context.getNode());
		}
		XmlUtils.removeThis(context.getNode());
		return null;
	}

	public GettingEL getMapEL() {
		return mapEL;
	}
	public void setMapEL(final GettingEL mapEL) {
		this.mapEL = mapEL;
	}
	public GettingEL getValueEL() {
		return valueEL;
	}
	public void setValueEL(final GettingEL valueEL) {
		this.valueEL = valueEL;
	}
}
