/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.convert;

import woolpack.fn.Fn;

public class ToSqlDateConverter<E extends Exception> implements Fn<Object, java.sql.Date, E> {
	public java.sql.Date exec(final Object c) {
		if (c instanceof java.sql.Date) {
			return (java.sql.Date) c;
		} else {
			return new java.sql.Date(((java.util.Date) c).getTime());
		}
	}
}
