/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import woolpack.fn.Fn;

public class ToLinkedHashMap<E extends Exception> implements Fn<ConfigContext, Void, E> {
	private String newMapListPosition;
	private String valueSourcePosition;
	private String labelSourcePosition;
	private String separator;

	public ToLinkedHashMap(
			final String newMapListPosition,
			final String valueSourcePosition,
			final String labelSourcePosition,
			final String separator) {
		this.newMapListPosition = newMapListPosition;
		this.valueSourcePosition = valueSourcePosition;
		this.labelSourcePosition = labelSourcePosition;
		this.separator = separator;
	}

	public Void exec(final ConfigContext context) {
		final String[] valueArray = ((String) context.getConfig().get(valueSourcePosition)).split(separator);
		final String[] labelArray = ((String) context.getConfig().get(labelSourcePosition)).split(separator);
		if (valueArray.length != labelArray.length) {
			throw new ArrayIndexOutOfBoundsException("length unmatch : "
					+ valueSourcePosition + " and " + labelSourcePosition);
		}
		final Map<String, String> map = new LinkedHashMap<String, String>();
		for (int i = 0; i < valueArray.length; i++) {
			map.put(valueArray[i], labelArray[i]);
		}
		context.getConfig().put(newMapListPosition, Collections.unmodifiableMap(map));
		return null;
	}

	public String getLabelSourcePosition() {
		return labelSourcePosition;
	}
	public void setLabelSourcePosition(final String labelSourcePosition) {
		this.labelSourcePosition = labelSourcePosition;
	}
	public String getNewMapListPosition() {
		return newMapListPosition;
	}
	public void setNewMapListPosition(final String newMapListPosition) {
		this.newMapListPosition = newMapListPosition;
	}
	public String getSeparator() {
		return separator;
	}
	public void setSeparator(final String separator) {
		this.separator = separator;
	}
	public String getValueSourcePosition() {
		return valueSourcePosition;
	}
	public void setValueSourcePosition(final String valueSourcePosition) {
		this.valueSourcePosition = valueSourcePosition;
	}
}
