/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.Locale;
import java.util.ResourceBundle;

import woolpack.fn.Fn;

public class ResourceBundleFactory<C, E extends Exception> implements Fn<C, ResourceBundle, E> {
	private String path;
	private Fn<? super C, ? extends Locale, ? extends E> fn;
	
	public ResourceBundleFactory(
			final String path,
			final Fn<? super C, ? extends Locale, ? extends E> fn) {
		this.path = path;
		this.fn = fn;
	}

	public ResourceBundle exec(final C c) throws E {
		final Locale l = fn.exec(c);
		return (l != null) ? ResourceBundle.getBundle(path, l) : ResourceBundle.getBundle(path);
	}

	public String getPath() {
		return path;
	}
	public void setPath(final String path) {
		this.path = path;
	}
	public Fn<? super C, ? extends Locale, ? extends E> getFn() {
		return fn;
	}
	public void setFn(final Fn<? super C, ? extends Locale, ? extends E> fn) {
		this.fn = fn;
	}
}
