/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.Enumeration;
import java.util.ResourceBundle;

import woolpack.fn.Fn;

public class PutResourceBundle<C extends ConfigContext, E extends Exception> implements Fn<C, Void, E> {
	private Fn<? super C, ? extends ResourceBundle, ? extends E> fn;

	public PutResourceBundle(final Fn<? super C, ? extends ResourceBundle, ? extends E> fn) {
		this.fn = fn;
	}

	public Void exec(final C c) throws E {
		final ResourceBundle b = fn.exec(c);
		for (final Enumeration<String> e = b.getKeys(); e.hasMoreElements();) {
			final String key = e.nextElement();
			c.getConfig().put(key, b.getObject(key));
		}
		return null;
	}

	public Fn<? super C, ? extends ResourceBundle, ? extends E> getFn() {
		return fn;
	}
	public void setFn(
			final Fn<? super C, ? extends ResourceBundle, ? extends E> fn) {
		this.fn = fn;
	}
}
