/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.bool;

import java.util.regex.Pattern;

import woolpack.fn.Fn;

public class RegExpChecker<E extends Exception> implements Fn<String, Boolean, E> {
	private Pattern pattern;
	
	public RegExpChecker(final Pattern pattern) {
		this.pattern = pattern;
	}

	public Boolean exec(final String c) {
		return pattern.matcher(c).matches();
	}

	public Pattern getPattern() {
		return pattern;
	}
	public void setPattern(final Pattern pattern) {
		this.pattern = pattern;
	}
}
