/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.bool;

import woolpack.fn.Fn;

public class ObjectMatcher<E extends Exception> implements Fn<Object, Boolean, E> {
	private Object value;
	
	public ObjectMatcher(final Object value) {
		this.value = value;
	}

	public Boolean exec(final Object c) {
		if (value == null) {
			return c == null;
		} else if (value instanceof Class) {
			return ((Class) value).isInstance(c);
		} else {
			return value.equals(c);
		}
	}

	public Object getValue() {
		return value;
	}
	public void setValue(final Object value) {
		this.value = value;
	}
}
