/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.adapter;

import java.util.Map;

import ognl.ObjectPropertyAccessor;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import woolpack.container.ContainerContext;

/**
 * Woolpack から OGNL を使い易くするためのユーティリティです。
 * <br/>適用しているデザインパターン：OGNLから見た{@link ContainerContext}のAdapter。
 * @author nakamura
 *
 */
public final class OGNLUtils {
	private OGNLUtils() {
	}
	
	/**
	 * OGNLから{@link ContainerContext#visit(Object)}に
	 * プロパティ名だけでアクセスするための設定を行います。
	 */
	public static void setting() {
		OgnlRuntime.setPropertyAccessor(
				ContainerContext.class,
				new ObjectPropertyAccessor() {
					@Override
					public Object getProperty(final Map cx, final Object target, final Object name) throws OgnlException {
						try {
							return ((ContainerContext) target).visit(name);
						} catch (final Exception e) {
							throw new IllegalStateException(e);
						}
					}
				});
	}
}
