/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;


/**
 * アクションの実行結果を表します。
 * <br/>適用しているデザインパターン：変数を格納するだけの構造体。
 * 
 * @author nakamura
 * 
 */
public class ActionResult {
	private ForwardDef forwardDef;
	private Object returnedObject;

	/**
	 * @param forwardDef 遷移先定義。
	 * @param returnedObject メソッドが返却したオブジェクト。
	 */
	public ActionResult(
			final ForwardDef forwardDef,
			final Object returnedObject) {
		this.forwardDef = forwardDef;
		this.returnedObject = returnedObject;
	}

	public ForwardDef getForwardDef() {
		return forwardDef;
	}
	public void setForwardDef(final ForwardDef forwardDef) {
		this.forwardDef = forwardDef;
	}
	public Object getReturnedObject() {
		return returnedObject;
	}
	public void setReturnedObject(final Object returnedObject) {
		this.returnedObject = returnedObject;
	}
}
