/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.acquirable;

import java.util.concurrent.Semaphore;

public class DoSemaphore implements Acquirable<InterruptedException> {
	private Semaphore semaphore;

	public DoSemaphore(final Semaphore semaphore) {
		this.semaphore = semaphore;
	}

	public boolean acquire() throws InterruptedException {
		semaphore.acquire();
		return true;
	}

	public void release() {
		semaphore.release();
	}

	public Semaphore getSemaphore() {
		return semaphore;
	}
	public void setSemaphore(final Semaphore semaphore) {
		this.semaphore = semaphore;
	}
}
