/*
 * Decompiled with CFR 0.152.
 */
package woolpack.xml;

import java.io.FileNotFoundException;
import java.io.Reader;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import woolpack.fn.Fn;
import woolpack.xml.XmlTransformerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFactory<C>
implements Fn<C, Node, Exception> {
    private Fn<? super C, ? extends Reader, ? extends Exception> readerFactory;
    private Fn<XmlTransformerContext, Void, ? extends Exception> transformer;

    public NodeFactory(Fn<? super C, ? extends Reader, ? extends Exception> readerFactory, Fn<XmlTransformerContext, Void, ? extends Exception> transformer) {
        this.readerFactory = readerFactory;
        this.transformer = transformer;
    }

    @Override
    public Node exec(C c) throws Exception {
        DOMResult result = new DOMResult();
        Reader r = this.readerFactory.exec(c);
        if (r == null) {
            throw new FileNotFoundException("not found : " + c);
        }
        try {
            XmlTransformerContext context = new XmlTransformerContext();
            context.setSource(new StreamSource(r));
            context.setResult(result);
            this.transformer.exec(context);
            Node node = result.getNode();
            return node;
        }
        finally {
            r.close();
        }
    }

    public Fn<? super C, ? extends Reader, ? extends Exception> getReaderFactory() {
        return this.readerFactory;
    }

    public void setReaderFactory(Fn<? super C, ? extends Reader, ? extends Exception> readerFactory) {
        this.readerFactory = readerFactory;
    }

    public Fn<XmlTransformerContext, Void, ? extends Exception> getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Fn<XmlTransformerContext, Void, ? extends Exception> transformer) {
        this.transformer = transformer;
    }
}

