/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.convert;

import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SqlOperator {
    EQ("EQ", SqlOperator.toRegExpCol("@s*@=@s*@?")),
    LT("LT", SqlOperator.toRegExpCol("@s*@<@s*@?")),
    GT("GT", SqlOperator.toRegExpCol("@s*@>@s*@?")),
    LE("LE", SqlOperator.toRegExpCol("@s*@<@=@s*@?")),
    GE("GE", SqlOperator.toRegExpCol("@s*@>@=@s*@?")),
    IN("IN", SqlOperator.toRegExpCol("@s+in@s+@(@?(@s*,@s*@?)*@s*@)")),
    LIKE("LIKE", SqlOperator.toRegExpCol("@s+like@s+@?")),
    BETWEEN("BETWEEN", SqlOperator.toRegExpCol("@s+between@s+@?@s+and@s+@?"));

    public static final int COL_GROUP = 1;
    public static final int BIND_GROUP = 2;
    private final String label;
    private final Pattern pattern;

    private static final Pattern toRegExp(String s) {
        return Pattern.compile(s.replaceAll("@", "\\\\"), 2);
    }

    private static final Pattern toRegExpCol(String operator) {
        return SqlOperator.toRegExp("([^,@s@(@)@<@>@=]+)(" + operator + ")");
    }

    private SqlOperator(String label, Pattern pattern) {
        this.label = label;
        this.pattern = pattern;
    }

    public String getLabel() {
        return this.label;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

