/*
 * Decompiled with CFR 0.152.
 */
package woolpack.misc;

import java.util.Locale;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.fn.SwitchFn;
import woolpack.misc.FnRunnable;
import woolpack.misc.LapTimeFn;
import woolpack.misc.LoadBalancer;
import woolpack.misc.RetryFn;
import woolpack.misc.RunnableFn;
import woolpack.misc.SleepFn;
import woolpack.misc.SwitchNearLocale;
import woolpack.misc.ThreadLocalGetter;
import woolpack.misc.TryLocales;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MiscUtils {
    private MiscUtils() {
    }

    public static <C, R, E extends Exception> Fn<C, R, E> lapTime(Fn<? super C, ? extends R, ? extends E> fn, Fn<? super Long, ?, ? extends E> reportFn) {
        return new LapTimeFn<C, R, E>(fn, reportFn);
    }

    public static <C, R, E extends Exception, E1 extends Exception> Fn<C, R, E> loadBalancer(Fn<Object, ? extends Fn<? super C, ? extends R, ? extends E>, ? extends E1> factory, int length) throws Exception {
        return new LoadBalancer(factory, length);
    }

    public static <C> FnRunnable<C> fnRunnable(Fn<? super C, ?, ? extends RuntimeException> fn, C c) {
        return new FnRunnable<C>(fn, c);
    }

    public static <R> Fn<Object, R, RuntimeException> runnableFn(Runnable runnable) {
        return new RunnableFn(runnable);
    }

    public static <C, R> Fn<C, R, InterruptedException> sleep(long sleepMillis) {
        return new SleepFn(sleepMillis);
    }

    public static <R, E extends Exception> Fn<Locale, R, E> switchNearLocale(SwitchFn<Locale, ? extends R, ? extends E> switching) {
        return new SwitchNearLocale<R, E>(switching);
    }

    public static <R> Fn<Object, R, RuntimeException> threadLocal(ThreadLocal<? extends R> threadLocal) {
        return new ThreadLocalGetter(threadLocal);
    }

    public static <R, E extends Exception> Fn<String, R, E> tryLocales(Fn<? super String, ? extends R, ? extends Exception> fn, ThreadLocal<Locale> threadLocal, Fn<? super Exception, ?, ? extends E> errorFn, Fn<? super Exception, ? extends R, ? extends E> finalFn) {
        return new TryLocales<R, E>(fn, threadLocal, errorFn, finalFn);
    }

    public static <R> Fn<String, R, IllegalStateException> tryLocales(Fn<? super String, ? extends R, ? extends Exception> fn, ThreadLocal<Locale> threadLocal) {
        return MiscUtils.tryLocales(fn, threadLocal, FnUtils.fixThrows(null), new Fn<Exception, R, IllegalStateException>(){

            @Override
            public R exec(Exception c) throws IllegalStateException {
                throw new IllegalStateException(c);
            }
        });
    }

    public static <C, R, E extends Exception> Fn<C, R, E> retry(Fn<? super C, ? extends R, ? extends Exception> fn, int count, Fn<? super Exception, ?, ? extends E> errorFn, Fn<? super Exception, ? extends R, ? extends E> finalFn) {
        return new RetryFn<C, R, E>(fn, count, errorFn, finalFn);
    }

    public static <C, R> Fn<C, R, IllegalStateException> retry(Fn<? super C, ? extends R, ? extends Exception> fn, int count) {
        return MiscUtils.retry(fn, count, FnUtils.fixThrows(null), new Fn<Exception, R, IllegalStateException>(){

            @Override
            public R exec(Exception c) throws IllegalStateException {
                throw new IllegalStateException(c);
            }
        });
    }
}

