/*
 * Decompiled with CFR 0.152.
 */
package woolpack.bool;

import java.util.Collection;
import java.util.regex.Pattern;
import woolpack.bool.BoolSeq;
import woolpack.bool.BooleanConverter;
import woolpack.bool.BooleanState;
import woolpack.bool.BooleanStateAndAndFactory;
import woolpack.bool.BooleanStateAndFactory;
import woolpack.bool.BooleanStateEqEqFactory;
import woolpack.bool.BooleanStateEqFactory;
import woolpack.bool.BooleanStateOrFactory;
import woolpack.bool.BooleanStateOrOrFactory;
import woolpack.bool.CompareFn;
import woolpack.bool.ContainsAllChecker;
import woolpack.bool.ContainsChecker;
import woolpack.bool.EqualsChecker;
import woolpack.bool.MaxChecker;
import woolpack.bool.MaxLengthChecker;
import woolpack.bool.MinChecker;
import woolpack.bool.MinLengthChecker;
import woolpack.bool.NotDelegator;
import woolpack.bool.NotEmptyChecker;
import woolpack.bool.NotFn;
import woolpack.bool.NullChecker;
import woolpack.bool.ObjectMatcher;
import woolpack.bool.RegExpChecker;
import woolpack.bool.ViewBooleanConverter;
import woolpack.fn.FixFn;
import woolpack.fn.Fn;
import woolpack.fn.IfFn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BoolUtils {
    public static final Fn<Object, Boolean, RuntimeException> NOT_THROWABLE = BoolUtils.not(BoolUtils.matchObject(Throwable.class));
    public static final Fn<Boolean, Boolean, RuntimeException> NOT = new NotFn<RuntimeException>();
    public static final Fn<Object, Boolean, RuntimeException> NOT_EMPTY = new NotEmptyChecker<RuntimeException>();
    public static final Fn<Object, Boolean, RuntimeException> IS_NULL = new NullChecker<RuntimeException>();
    public static final Fn<Object, Boolean, RuntimeException> TO_BOOLEAN = new BooleanConverter<RuntimeException>();
    public static final Fn<Object, Boolean, RuntimeException> TO_BOOLEAN_VIEW = new ViewBooleanConverter<RuntimeException>();
    public static final Fn<Object, BooleanState, RuntimeException> ANDAND = new BooleanStateAndAndFactory();
    public static final Fn<Object, BooleanState, RuntimeException> AND = new BooleanStateAndFactory();
    public static final Fn<Object, BooleanState, RuntimeException> EQEQ = new BooleanStateEqEqFactory();
    public static final Fn<Object, BooleanState, RuntimeException> EQ = new BooleanStateEqFactory();
    public static final Fn<Object, BooleanState, RuntimeException> OR = new BooleanStateOrFactory();
    public static final Fn<Object, BooleanState, RuntimeException> OROR = new BooleanStateOrOrFactory();

    private BoolUtils() {
    }

    public static <C, E extends Exception> Fn<C, Boolean, E> boolSeq(Fn<Object, ? extends BooleanState, ? extends RuntimeException> factory, Iterable<? extends Fn<? super C, Boolean, ? extends E>> iterable) {
        return new BoolSeq(factory, iterable);
    }

    public static <C extends Comparable<C>> Fn<C, Integer, RuntimeException> compare(C value) {
        return new CompareFn(value);
    }

    public static Fn<Collection<?>, Boolean, RuntimeException> containsAll(Collection<?> value) {
        return new ContainsAllChecker(value);
    }

    public static Fn<Object, Boolean, RuntimeException> contains(Collection<?> value) {
        return new ContainsChecker<RuntimeException>(value);
    }

    public static Fn<Object, Boolean, RuntimeException> checkEquals(Object value) {
        return new EqualsChecker<RuntimeException>(value);
    }

    public static <C extends Comparable<C>> Fn<C, Boolean, RuntimeException> checkMax(C value) {
        return new MaxChecker(value);
    }

    public static Fn<String, Boolean, RuntimeException> checkMaxLength(int value) {
        return new MaxLengthChecker<RuntimeException>(value);
    }

    public static <C extends Comparable<C>> Fn<C, Boolean, RuntimeException> checkMin(C value) {
        return new MinChecker(value);
    }

    public static Fn<String, Boolean, RuntimeException> checkMinLength(int value) {
        return new MinLengthChecker<RuntimeException>(value);
    }

    public static <C, E extends Exception> Fn<C, Boolean, E> not(Fn<? super C, Boolean, ? extends E> fn) {
        return new NotDelegator<C, E>(fn);
    }

    public static Fn<Object, Boolean, RuntimeException> matchObject(Object value) {
        return new ObjectMatcher<RuntimeException>(value);
    }

    public static Fn<String, Boolean, RuntimeException> checkRegExp(Pattern pattern) {
        return new RegExpChecker<RuntimeException>(pattern);
    }

    public static <C, E extends Exception> Fn<C, Boolean, E> ifTrue(Fn<? super C, ?, ? extends E> ifFn, Fn<? super C, ? extends Boolean, ? extends E> trueFn) {
        return new IfFn<C, Boolean, E>(ifFn, trueFn, new FixFn(false));
    }

    public static <C, E extends Exception> Fn<C, Boolean, E> ifNot(Fn<? super C, ?, ? extends E> ifFn, Fn<? super C, ? extends Boolean, ? extends E> falseFn) {
        return new IfFn<C, Boolean, E>(ifFn, new FixFn(true), falseFn);
    }
}

