/*
 * Decompiled with CFR 0.152.
 */
package woolpack.web;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import woolpack.container.ContainerContext;
import woolpack.container.ContainerUtils;
import woolpack.el.AbstractGettingEL;
import woolpack.el.GettingEL;
import woolpack.factory.ConcurrentMapCache;
import woolpack.factory.FactoryUtils;
import woolpack.factory.MapCache;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.web.ContainerContextSetter;
import woolpack.web.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebUtils {
    public static final GettingEL REQUEST_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getRequest();
        }
    };
    public static final GettingEL SESSION_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getSession();
        }
    };
    public static final GettingEL APPLICATION_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getApplication();
        }
    };
    public static final Fn<WebContext, Void, RuntimeException> CLEAR_SESSION = new Fn<WebContext, Void, RuntimeException>(){

        @Override
        public Void exec(WebContext context) {
            context.getSession().clear();
            return null;
        }
    };

    private static <E extends Exception> Fn<ContainerContext<WebContext>, String, Exception> getKey() {
        return new Fn<ContainerContext<WebContext>, String, Exception>(){

            @Override
            public String exec(ContainerContext<WebContext> c) {
                return "woolpack.web.WebUtils." + c.getKey();
            }
        };
    }

    private WebUtils() {
    }

    public static <E extends Exception> Fn<WebContext, Map<String, Object>, E> requestFn() {
        return new Fn<WebContext, Map<String, Object>, E>(){

            @Override
            public Map<String, Object> exec(WebContext c) {
                return c.getRequest();
            }
        };
    }

    public static <E extends Exception> Fn<WebContext, ConcurrentMap<String, Object>, E> sessionFn() {
        return new Fn<WebContext, ConcurrentMap<String, Object>, E>(){

            @Override
            public ConcurrentMap<String, Object> exec(WebContext c) {
                return c.getSession();
            }
        };
    }

    public static <E extends Exception> Fn<WebContext, ConcurrentMap<String, Object>, E> applicationFn() {
        return new Fn<WebContext, ConcurrentMap<String, Object>, E>(){

            @Override
            public ConcurrentMap<String, Object> exec(WebContext c) {
                return c.getApplication();
            }
        };
    }

    public static <C extends ContainerContext<WebContext>> MapCache<C, String, Exception> request(Fn<? super C, ?, ? extends Exception> fn) {
        return FactoryUtils.cache(FnUtils.join(ContainerUtils.getSubContext(), WebUtils.requestFn()), WebUtils.getKey(), fn);
    }

    public static <C extends ContainerContext<WebContext>> ConcurrentMapCache<C, String, Exception> session(Fn<? super C, ?, ? extends Exception> fn) {
        return FactoryUtils.concurrentCache(FnUtils.join(ContainerUtils.getSubContext(), WebUtils.sessionFn()), WebUtils.getKey(), fn);
    }

    public static <C extends ContainerContext<WebContext>> ConcurrentMapCache<C, String, Exception> application(Fn<? super C, ?, ? extends Exception> fn) {
        return FactoryUtils.concurrentCache(FnUtils.join(ContainerUtils.getSubContext(), WebUtils.applicationFn()), WebUtils.getKey(), fn);
    }

    public static Fn<WebContext, Void, RuntimeException> setContainerContext(Fn<? super ContainerContext<WebContext>, ?, ? extends Exception> fn) {
        return new ContainerContextSetter<RuntimeException>(fn);
    }
}

