/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.convert;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import woolpack.sql.fn.PreparedStatementInfo;

public final class SqlCommentUtils {
    private static final Pattern BIND_COMMENT_SQL_PATTERN = Pattern.compile("[^@s,@(@)]*/@*([^@*@s]+)@s*@*/[^@s,@(@)]*".replaceAll("@", "\\\\"));
    private static final String BIND_COMMENT_SQL_PATTERN_REPLACEMENT = "?";
    private static final Pattern COMMENT_SQL_PATTERN = Pattern.compile("/@*@s+[^@*]*@*/".replaceAll("@", "\\\\"));
    private static final String COMMENT_SQL_PATTERN_REPLACEMENT = "";

    private SqlCommentUtils() {
    }

    public static PreparedStatementInfo toPreparedStatementInfo(String s) {
        PreparedStatementInfo info = new PreparedStatementInfo();
        ArrayList<String> list = new ArrayList<String>();
        info.setList(list);
        StringBuffer sb = new StringBuffer(s.length());
        Matcher m = BIND_COMMENT_SQL_PATTERN.matcher(s);
        while (m.find()) {
            list.add(m.group(1));
            m.appendReplacement(sb, BIND_COMMENT_SQL_PATTERN_REPLACEMENT);
        }
        m.appendTail(sb);
        info.setQuery(COMMENT_SQL_PATTERN.matcher(sb.toString()).replaceAll(COMMENT_SQL_PATTERN_REPLACEMENT));
        return info;
    }
}

