/*
 * Decompiled with CFR 0.152.
 */
package woolpack.convert;

import java.text.Format;
import java.util.Collection;
import java.util.regex.Pattern;
import woolpack.convert.CloneFormatFactory;
import woolpack.convert.FormatConverter;
import woolpack.convert.KeySetGetter;
import woolpack.convert.NetMaskConverter;
import woolpack.convert.ParseConverter;
import woolpack.convert.RegExpConverter;
import woolpack.convert.RetainKeys;
import woolpack.convert.ToBigDecimalConverter;
import woolpack.convert.ToBigIntegerConverter;
import woolpack.convert.ToByteConverter;
import woolpack.convert.ToCalendarConverter;
import woolpack.convert.ToDoubleConverter;
import woolpack.convert.ToFloatConverter;
import woolpack.convert.ToIntegerConverter;
import woolpack.convert.ToLongConverter;
import woolpack.convert.ToShortConverter;
import woolpack.convert.ToSqlDateConverter;
import woolpack.convert.ToStringConverter;
import woolpack.convert.ToTimeConverter;
import woolpack.convert.ToTimestampConverter;
import woolpack.convert.TrysFn;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConvertUtils {
    public static final ToBigDecimalConverter<RuntimeException> TO_BIG_DECIMAL = new ToBigDecimalConverter();
    public static final ToBigIntegerConverter<RuntimeException> TO_BIG_INTEGER = new ToBigIntegerConverter();
    public static final ToByteConverter<RuntimeException> TO_BYTE = new ToByteConverter();
    public static final ToDoubleConverter<RuntimeException> TO_DOUBLE = new ToDoubleConverter();
    public static final ToFloatConverter<RuntimeException> TO_FLOAT = new ToFloatConverter();
    public static final ToIntegerConverter<RuntimeException> TO_INTEGER = new ToIntegerConverter();
    public static final ToLongConverter<RuntimeException> TO_LONG = new ToLongConverter();
    public static final ToShortConverter<RuntimeException> TO_SHORT = new ToShortConverter();
    public static final ToSqlDateConverter<RuntimeException> TO_SQL_DATE = new ToSqlDateConverter();
    public static final ToTimeConverter<RuntimeException> TO_TIME = new ToTimeConverter();
    public static final ToTimestampConverter<RuntimeException> TO_TIMESTAMP = new ToTimestampConverter();
    public static final ToCalendarConverter<RuntimeException> TO_CALENDAR = new ToCalendarConverter();
    public static final ToStringConverter<RuntimeException> TO_STRING = new ToStringConverter();

    private ConvertUtils() {
    }

    public static <K> KeySetGetter<K, RuntimeException> keySet() {
        return new KeySetGetter();
    }

    public static CloneFormatFactory<RuntimeException> formatFactory(Format format) {
        return new CloneFormatFactory<RuntimeException>(format);
    }

    public static <E extends Exception> FormatConverter<E> format(Fn<?, ? extends Format, ? extends E> formatFactory) {
        return new FormatConverter<E>(formatFactory);
    }

    public static NetMaskConverter<RuntimeException> netMask(String netMask) {
        return new NetMaskConverter<RuntimeException>(netMask);
    }

    public static ParseConverter parse(Fn<?, ? extends Format, ? extends Exception> formatFactory) {
        return new ParseConverter(formatFactory);
    }

    public static RegExpConverter<RuntimeException> convertRegExp(Pattern pattern, String replacement) {
        return new RegExpConverter<RuntimeException>(pattern, replacement);
    }

    public static <C, R, E extends Exception> TrysFn<C, R, E> trys(Iterable<? extends Fn<? super C, ? extends R, ? extends Exception>> iterable, Fn<? super Exception, ?, ? extends E> errorFn, Fn<? super Exception, ? extends R, ? extends E> finalFn) {
        return new TrysFn(iterable, errorFn, finalFn);
    }

    public static <C, R> TrysFn<C, R, IllegalStateException> trys(Iterable<? extends Fn<? super C, ? extends R, ? extends Exception>> iterable) {
        return new TrysFn(iterable, FnUtils.fixThrows(null), new Fn<Exception, R, IllegalStateException>(){

            @Override
            public R exec(Exception c) throws IllegalStateException {
                throw new IllegalStateException(c);
            }
        });
    }

    public static RetainKeys<RuntimeException> retainKeys(Collection<?> collection) {
        return new RetainKeys<RuntimeException>(collection);
    }
}

