/*
 * Decompiled with CFR 0.152.
 */
package woolpack.acquirable;

import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import woolpack.acquirable.Acquirable;
import woolpack.acquirable.AcquirableChain;
import woolpack.acquirable.AcquireFn;
import woolpack.acquirable.DoLock;
import woolpack.acquirable.DoSemaphore;
import woolpack.acquirable.TryLock;
import woolpack.acquirable.TrySemaphore;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcquirableUtils {
    public static final Acquirable<RuntimeException> ANY = new Acquirable<RuntimeException>(){

        @Override
        public boolean acquire() {
            return true;
        }

        @Override
        public void release() {
        }
    };
    public static final Acquirable<RuntimeException> NONE = new Acquirable<RuntimeException>(){

        @Override
        public boolean acquire() {
            return false;
        }

        @Override
        public void release() {
        }
    };
    public static final Acquirable<RuntimeException> INTERRUPT = new Acquirable<RuntimeException>(){

        @Override
        public boolean acquire() {
            Thread.currentThread().interrupt();
            return false;
        }

        @Override
        public void release() {
        }
    };
    public static final Acquirable<InterruptedException> INTERRUPTED_EXCEPTION = new Acquirable<InterruptedException>(){

        @Override
        public boolean acquire() throws InterruptedException {
            Thread.currentThread().interrupt();
            throw new InterruptedException();
        }

        @Override
        public void release() {
        }
    };

    private AcquirableUtils() {
    }

    public static <C, R, E extends Exception> AcquireFn<C, R, E> acquire(Fn<? super C, ? extends Acquirable<? extends E>, ? extends E> acquireGetter, Fn<? super C, ? extends R, ? extends E> trueFn, Fn<? super C, ? extends R, ? extends E> falseFn) {
        return new AcquireFn<C, R, E>(acquireGetter, trueFn, falseFn);
    }

    public static DoLock<RuntimeException> doLock(Lock lock) {
        return new DoLock<RuntimeException>(lock);
    }

    public static DoSemaphore doSemaphore(Semaphore semaphore) {
        return new DoSemaphore(semaphore);
    }

    public static TryLock<RuntimeException> tryLock(Lock lock) {
        return new TryLock<RuntimeException>(lock);
    }

    public static TrySemaphore<RuntimeException> trySemaphore(Semaphore semaphore) {
        return new TrySemaphore<RuntimeException>(semaphore);
    }

    public static <E extends Exception> AcquirableChain<E> chain(List<? extends Acquirable<? extends E>> list) {
        return new AcquirableChain(list);
    }
}

