/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.fn;

public class ThrowFn<C, R, E extends Exception> implements Fn<C, R, E> {
	private E exception;
	
	public ThrowFn(final E exception) {
		this.exception = exception;
	}

	public R exec(final C c) throws E {
		throw exception;
	}

	public E getException() {
		return exception;
	}
	public void setException(final E exception) {
		this.exception = exception;
	}
}
