/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.acquirable;

import java.util.concurrent.locks.Lock;

/**
 * {@link #acquire()}で{@link Lock#tryLock()}を実行し、
 * {@link #release()}で{@link Lock#unlock()}を実行する{@link Acquirable}です。
 * <br/>適用しているデザインパターン：Adapter。
 * 
 * @author nakamura
 * 
 */
public class TryLock<E extends Exception> implements Acquirable<E> {
	private Lock lock;

	public TryLock(final Lock lock) {
		this.lock = lock;
	}

	public boolean acquire() throws E {
		return lock.tryLock();
	}

	public void release() {
		lock.unlock();
	}

	public Lock getLock() {
		return lock;
	}
	public void setLock(final Lock lock) {
		this.lock = lock;
	}
}
