/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import woolpack.el.EL;
import woolpack.el.ELUtils;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.sql.fn.BeanInput;
import woolpack.sql.fn.BeanResult;
import woolpack.sql.fn.CountResult;
import woolpack.sql.fn.ListResult;
import woolpack.sql.fn.OneLineResult;
import woolpack.sql.fn.PreparedStatementInfo;
import woolpack.sql.fn.SingleInput;
import woolpack.sql.fn.SingleResult;
import woolpack.sql.fn.StatementInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFnUtils {
    public static final Fn<Statement, Integer, SQLException> GET_COUNT = new CountResult();
    public static final Fn<ResultSet, Object, SQLException> GET_SINGLE = new SingleResult();

    private SqlFnUtils() {
    }

    public static <R> Fn<ResultSet, R, Exception> getBeanResult(Fn<? super ResultSet, ? extends R, ? extends Exception> beanFactory) {
        return SqlFnUtils.getBeanResult(beanFactory, ELUtils.EL_FACTORY);
    }

    public static <R> Fn<ResultSet, R, Exception> getBeanResult(Fn<? super ResultSet, ? extends R, ? extends Exception> beanFactory, Fn<String, EL, ? extends Exception> elFactory) {
        return new BeanResult<R>(beanFactory, elFactory);
    }

    public static <R> Fn<Statement, List<R>, Exception> getList(Fn<? super ResultSet, ? extends R, ? extends Exception> fn, int max, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return new ListResult<R>(fn, max, errorFn);
    }

    public static <R> Fn<Statement, List<R>, Exception> getList(Fn<? super ResultSet, ? extends R, ? extends Exception> fn, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return SqlFnUtils.getList(fn, Integer.MAX_VALUE, errorFn);
    }

    public static <C, R> Fn<C, R, Exception> inputBean(DataSource dataSource, Fn<? super C, ? extends PreparedStatementInfo, ? extends Exception> queryFactory, Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return new BeanInput<C, R>(dataSource, queryFactory, converter, errorFn, ELUtils.EL_FACTORY);
    }

    public static <C, R> Fn<C, R, Exception> inputBean(DataSource dataSource, PreparedStatementInfo info, Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return SqlFnUtils.inputBean(dataSource, FnUtils.fix(info), converter, errorFn);
    }

    public static <R> Fn<Statement, R, Exception> getOne(Fn<? super ResultSet, ? extends R, ? extends Exception> rowFn, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return new OneLineResult<R>(rowFn, errorFn);
    }

    public static <C, R> Fn<C, R, Exception> inputSingle(DataSource dataSource, Fn<? super C, ? extends String, ? extends Exception> queryFactory, Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return new SingleInput<C, R>(dataSource, queryFactory, converter, errorFn);
    }

    public static <C, R> Fn<C, R, Exception> inputSingle(DataSource dataSource, String query, Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return SqlFnUtils.inputSingle(dataSource, FnUtils.fix(query), converter, errorFn);
    }

    public static <C, R> Fn<C, R, Exception> inputStatement(DataSource dataSource, Fn<? super C, ? extends String, ? extends Exception> queryFactory, Fn<? super Statement, ? extends R, ? extends Exception> converter, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return new StatementInput<C, R>(dataSource, queryFactory, converter, errorFn);
    }

    public static <C, R> Fn<C, R, Exception> inputStatement(DataSource dataSource, String query, Fn<? super Statement, ? extends R, ? extends Exception> converter, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return SqlFnUtils.inputStatement(dataSource, FnUtils.fix(query), converter, errorFn);
    }
}

