/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneLineResult<R>
implements Fn<Statement, R, Exception> {
    private Fn<? super ResultSet, ? extends R, ? extends Exception> rowFn;
    private Fn<? super SQLException, ?, ? extends Exception> errorFn;

    public OneLineResult(Fn<? super ResultSet, ? extends R, ? extends Exception> rowFn, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        this.rowFn = rowFn;
        this.errorFn = errorFn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R exec(Statement c) throws Exception {
        SQLException e0;
        block7: {
            e0 = null;
            try {
                ResultSet resultSet = c.getResultSet();
                try {
                    if (!resultSet.next()) return null;
                    R r = this.rowFn.exec(resultSet);
                    return r;
                }
                catch (SQLException e1) {
                    this.errorFn.exec(e1);
                    e0 = e1;
                }
                finally {
                    resultSet.close();
                }
            }
            catch (SQLException e12) {
                this.errorFn.exec(e12);
                if (e0 != null) break block7;
                e0 = e12;
            }
        }
        if (e0 == null) return null;
        throw e0;
    }

    public Fn<? super ResultSet, ? extends R, ? extends Exception> getRowFn() {
        return this.rowFn;
    }

    public void setRowFn(Fn<? super ResultSet, ? extends R, ? extends Exception> fn) {
        this.rowFn = fn;
    }

    public Fn<? super SQLException, ?, ? extends Exception> getErrorFn() {
        return this.errorFn;
    }

    public void setErrorFn(Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        this.errorFn = errorFn;
    }
}

