/*
 * Decompiled with CFR 0.152.
 */
package woolpack.misc;

import java.util.Locale;
import woolpack.fn.Fn;
import woolpack.fn.SwitchFn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchNearLocale<R, E extends Exception>
implements Fn<Locale, R, E> {
    private static final int LOCALE_DEPTH = 3;
    private SwitchFn<Locale, ? extends R, ? extends E> switching;

    public SwitchNearLocale(SwitchFn<Locale, ? extends R, ? extends E> switching) {
        this.switching = switching;
    }

    private static int calcLocaleCount(Locale key) {
        return key.getVariant() != null && key.getVariant().length() > 0 ? 3 : (key.getCountry() != null && key.getCountry().length() > 0 ? 2 : 1);
    }

    @Override
    public R exec(Locale c) throws E {
        R r = this.switching.getMap().get(c);
        if (r != null) {
            return r;
        }
        if (c == null) {
            return this.switching.getDefaultFn().exec(c);
        }
        int keyCount = SwitchNearLocale.calcLocaleCount(c);
        Locale l0 = null;
        int count0 = 0;
        for (Locale object : this.switching.getMap().keySet()) {
            Locale l1;
            if (!(object instanceof Locale) || keyCount < SwitchNearLocale.calcLocaleCount(l1 = object)) continue;
            int count1 = 0;
            if (c.getLanguage() != null && c.getLanguage().equals(l1.getLanguage())) {
                ++count1;
                if (c.getCountry() != null && c.getCountry().equals(l1.getCountry())) {
                    ++count1;
                }
            }
            if (count0 >= count1) continue;
            count0 = count1;
            l0 = l1;
        }
        if (l0 == null) {
            return this.switching.getDefaultFn().exec(c);
        }
        return this.switching.exec(l0);
    }

    public SwitchFn<Locale, ? extends R, ? extends E> getSwitching() {
        return this.switching;
    }

    public void setSwitching(SwitchFn<Locale, ? extends R, ? extends E> switching) {
        this.switching = switching;
    }
}

