/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import woolpack.fn.Fn;
import woolpack.sql.fn.PreparedStatementInfo;
import woolpack.sql.meta.ColumnInfo;
import woolpack.sql.meta.MarkableStringBuilder;
import woolpack.sql.meta.ReferenceInfo;
import woolpack.sql.meta.TableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMetaUtils {
    private static final String COMMA = ", ";
    private static final String DOT = ".";
    private static final String AND = " AND ";
    private static final String WHERE = " WHERE ";
    private static final String SET = " SET ";
    private static final String EQUAL = " = ";
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String HATENA = "?";
    public static final Fn<TableInfo, PreparedStatementInfo, RuntimeException> INSERT_FACTORY = new Fn<TableInfo, PreparedStatementInfo, RuntimeException>(){

        @Override
        public PreparedStatementInfo exec(TableInfo c) {
            MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 2);
            sb.append("INSERT INTO ");
            sb.append(c.getTableName());
            sb.append('(');
            sb.mark(0);
            sb.append(") VALUES (");
            sb.mark(1);
            sb.append(')');
            ArrayList<String> list = new ArrayList<String>(c.getColNameList().size());
            for (String column : c.getColNameList()) {
                sb.insert(0, SqlMetaUtils.EMPTY, SqlMetaUtils.COMMA);
                sb.insert(0, column);
                sb.insert(1, SqlMetaUtils.EMPTY, SqlMetaUtils.COMMA);
                sb.insert(1, SqlMetaUtils.HATENA);
                list.add(column);
            }
            return new PreparedStatementInfo(sb.toString(), list);
        }
    };
    public static final Fn<TableInfo, PreparedStatementInfo, RuntimeException> SELECT_FACTORY = new Fn<TableInfo, PreparedStatementInfo, RuntimeException>(){

        @Override
        public PreparedStatementInfo exec(TableInfo c) {
            MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 2);
            sb.append("SELECT ");
            sb.mark(0);
            sb.append(" FROM ");
            sb.append(c.getTableName());
            sb.mark(1);
            ArrayList<String> list = new ArrayList<String>(c.getColNameList().size());
            for (String column : c.getColNameList()) {
                if (c.getPkNameList().contains(column)) {
                    sb.insert(1, SqlMetaUtils.WHERE, SqlMetaUtils.AND);
                    sb.insert(1, column);
                    sb.insert(1, SqlMetaUtils.EQUAL);
                    sb.insert(1, SqlMetaUtils.HATENA);
                    list.add(column);
                }
                sb.insert(0, SqlMetaUtils.EMPTY, SqlMetaUtils.COMMA);
                sb.insert(0, column);
            }
            return new PreparedStatementInfo(sb.toString(), list);
        }
    };
    public static final Fn<TableInfo, PreparedStatementInfo, RuntimeException> UPDATE_FACTORY = new Fn<TableInfo, PreparedStatementInfo, RuntimeException>(){

        @Override
        public PreparedStatementInfo exec(TableInfo c) {
            MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 2);
            sb.append("UPDATE ");
            sb.append(c.getTableName());
            sb.mark(0);
            sb.append(SqlMetaUtils.SPACE);
            sb.mark(1);
            ArrayList<String> list = new ArrayList<String>(c.getColNameList().size());
            int setPosition = 0;
            for (String column : c.getColNameList()) {
                if (c.getPkNameList().contains(column)) {
                    sb.insert(1, SqlMetaUtils.WHERE, SqlMetaUtils.AND);
                    sb.insert(1, column);
                    sb.insert(1, SqlMetaUtils.EQUAL);
                    sb.insert(1, SqlMetaUtils.HATENA);
                    list.add(column);
                    continue;
                }
                sb.insert(0, SqlMetaUtils.SET, SqlMetaUtils.COMMA);
                sb.insert(0, column);
                sb.insert(0, SqlMetaUtils.EQUAL);
                sb.insert(0, SqlMetaUtils.HATENA);
                list.add(setPosition, column);
                ++setPosition;
            }
            return new PreparedStatementInfo(sb.toString(), list);
        }
    };
    public static final Fn<TableInfo, PreparedStatementInfo, RuntimeException> DELETE_FACTORY = new Fn<TableInfo, PreparedStatementInfo, RuntimeException>(){

        @Override
        public PreparedStatementInfo exec(TableInfo c) {
            MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 1);
            sb.append("DELETE FROM ");
            sb.append(c.getTableName());
            sb.mark(0);
            ArrayList<String> list = new ArrayList<String>(c.getPkNameList().size());
            for (String column : c.getPkNameList()) {
                sb.insert(0, SqlMetaUtils.WHERE, SqlMetaUtils.AND);
                sb.insert(0, column);
                sb.insert(0, SqlMetaUtils.EQUAL);
                sb.insert(0, SqlMetaUtils.HATENA);
                list.add(column);
            }
            return new PreparedStatementInfo(sb.toString(), list);
        }
    };
    public static final Fn<TableInfo, Fn<Collection<String>, PreparedStatementInfo, RuntimeException>, RuntimeException> INSERT_FACTORY_FACTORY = new Fn<TableInfo, Fn<Collection<String>, PreparedStatementInfo, RuntimeException>, RuntimeException>(){

        @Override
        public Fn<Collection<String>, PreparedStatementInfo, RuntimeException> exec(final TableInfo c0) {
            return new Fn<Collection<String>, PreparedStatementInfo, RuntimeException>(){

                @Override
                public PreparedStatementInfo exec(Collection<String> c1) {
                    return INSERT_FACTORY.exec(SqlMetaUtils.retain(c0, c1));
                }
            };
        }
    };
    public static final Fn<TableInfo, Fn<Collection<String>, PreparedStatementInfo, RuntimeException>, RuntimeException> UPDATE_FACTORY_FACTORY = new Fn<TableInfo, Fn<Collection<String>, PreparedStatementInfo, RuntimeException>, RuntimeException>(){

        @Override
        public Fn<Collection<String>, PreparedStatementInfo, RuntimeException> exec(final TableInfo c0) {
            return new Fn<Collection<String>, PreparedStatementInfo, RuntimeException>(){

                @Override
                public PreparedStatementInfo exec(Collection<String> c1) {
                    return UPDATE_FACTORY.exec(SqlMetaUtils.retain(c0, c1));
                }
            };
        }
    };
    public static final Fn<TableInfo, Fn<Collection<String>, PreparedStatementInfo, RuntimeException>, RuntimeException> SELECT_FACTORY_FACTORY = new Fn<TableInfo, Fn<Collection<String>, PreparedStatementInfo, RuntimeException>, RuntimeException>(){

        @Override
        public Fn<Collection<String>, PreparedStatementInfo, RuntimeException> exec(final TableInfo c0) {
            return new Fn<Collection<String>, PreparedStatementInfo, RuntimeException>(){

                @Override
                public PreparedStatementInfo exec(Collection<String> c1) {
                    MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 2);
                    sb.append("SELECT ");
                    sb.mark(0);
                    sb.append(" FROM ");
                    sb.append(c0.getTableName());
                    sb.mark(1);
                    ArrayList<String> list = new ArrayList<String>(c1.size());
                    for (String column : c0.getColNameList()) {
                        if (c1.contains(column)) {
                            sb.insert(1, SqlMetaUtils.WHERE, SqlMetaUtils.AND);
                            sb.insert(1, column);
                            sb.insert(1, SqlMetaUtils.EQUAL);
                            sb.insert(1, SqlMetaUtils.HATENA);
                            list.add(column);
                        }
                        sb.insert(0, SqlMetaUtils.EMPTY, SqlMetaUtils.COMMA);
                        sb.insert(0, column);
                    }
                    return new PreparedStatementInfo(sb.toString(), list);
                }
            };
        }
    };
    public static final Fn<List<TableInfo>, Fn<Collection<String>, PreparedStatementInfo, RuntimeException>, RuntimeException> JOIN_SELECT_FACTORY_FACTORY = new Fn<List<TableInfo>, Fn<Collection<String>, PreparedStatementInfo, RuntimeException>, RuntimeException>(){

        @Override
        public Fn<Collection<String>, PreparedStatementInfo, RuntimeException> exec(final List<TableInfo> c0) {
            return new Fn<Collection<String>, PreparedStatementInfo, RuntimeException>(){

                @Override
                public PreparedStatementInfo exec(Collection<String> c1) {
                    MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 3);
                    sb.append("SELECT ");
                    sb.mark(0);
                    sb.append(" FROM ");
                    sb.mark(1);
                    sb.append(SqlMetaUtils.SPACE);
                    sb.mark(2);
                    ArrayList<String> list = new ArrayList<String>(c1.size());
                    for (TableInfo tableInfo : c0) {
                        sb.insert(1, SqlMetaUtils.EMPTY, SqlMetaUtils.COMMA);
                        sb.insert(1, tableInfo.getTableName());
                        for (String column : tableInfo.getColNameList()) {
                            if (c1.contains(column)) {
                                sb.insert(2, SqlMetaUtils.WHERE, SqlMetaUtils.AND);
                                sb.insert(2, tableInfo.getTableName());
                                sb.insert(2, SqlMetaUtils.DOT);
                                sb.insert(2, column);
                                sb.insert(2, SqlMetaUtils.EQUAL);
                                sb.insert(2, SqlMetaUtils.HATENA);
                                list.add(column);
                            }
                            sb.insert(0, SqlMetaUtils.EMPTY, SqlMetaUtils.COMMA);
                            sb.insert(0, tableInfo.getTableName());
                            sb.insert(0, SqlMetaUtils.DOT);
                            sb.insert(0, column);
                        }
                        block2: for (ReferenceInfo referenceInfo : tableInfo.getImportedKeysList()) {
                            for (TableInfo tmp : c0) {
                                if (!referenceInfo.getPkTableName().equals(tmp.getTableName())) continue;
                                int size = referenceInfo.getPkNameList().size();
                                int i = 0;
                                while (i < size) {
                                    sb.insert(2, SqlMetaUtils.WHERE, SqlMetaUtils.AND);
                                    sb.insert(2, referenceInfo.getPkTableName());
                                    sb.insert(2, SqlMetaUtils.DOT);
                                    sb.insert(2, referenceInfo.getPkNameList().get(i));
                                    sb.insert(2, SqlMetaUtils.EQUAL);
                                    sb.insert(2, referenceInfo.getFkTableName());
                                    sb.insert(2, SqlMetaUtils.DOT);
                                    sb.insert(2, referenceInfo.getFkNameList().get(i));
                                    ++i;
                                }
                                continue block2;
                            }
                        }
                    }
                    return new PreparedStatementInfo(sb.toString(), list);
                }
            };
        }
    };

    private SqlMetaUtils() {
    }

    private static TableInfo retain(TableInfo base, Collection<String> retainList) {
        TableInfo result = new TableInfo();
        result.setTableName(base.getTableName());
        result.setColNameList(new ArrayList<String>(base.getColNameList()));
        result.getColNameList().retainAll(retainList);
        result.setPkNameList(new ArrayList<String>(base.getPkNameList()));
        result.getPkNameList().retainAll(retainList);
        return result;
    }

    public static List<String> generateCreateQuery(Collection<TableInfo> inList) {
        ArrayList<String> outList = new ArrayList<String>();
        for (TableInfo tableInfo : inList) {
            outList.add(SqlMetaUtils.generateCreateTableQuery(tableInfo));
            if (tableInfo.getPkNameList().size() > 0) {
                outList.add(SqlMetaUtils.generateAlterPrimaryKeyQuery(tableInfo));
            }
            for (ReferenceInfo refInfo : tableInfo.getImportedKeysList()) {
                outList.add(SqlMetaUtils.generateAlterForeignKeyQuery(refInfo));
            }
        }
        return outList;
    }

    public static String generateCreateTableQuery(TableInfo info) {
        MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 2);
        sb.append("CREATE TABLE ");
        sb.append(info.getTableName());
        sb.append(" (");
        sb.mark(0);
        sb.append(")");
        for (String colName : info.getColNameList()) {
            ColumnInfo colInfo = info.getColumnInfoMap().get(colName);
            sb.insert(0, EMPTY, COMMA);
            sb.insert(0, colName);
            sb.insert(0, SPACE);
            sb.insert(0, colInfo.getTypeName());
        }
        return sb.toString();
    }

    public static String generateAlterPrimaryKeyQuery(TableInfo info) {
        MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 2);
        sb.append("ALTER TABLE ");
        sb.append(info.getTableName());
        sb.append(" ADD PRIMARY KEY (");
        sb.mark(0);
        sb.append(")");
        for (String colName : info.getPkNameList()) {
            sb.insert(0, EMPTY, COMMA);
            sb.insert(0, colName);
        }
        return sb.toString();
    }

    public static String generateAlterForeignKeyQuery(ReferenceInfo info) {
        MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 2);
        sb.append("ALTER TABLE ");
        sb.append(info.getFkTableName());
        sb.append(" ADD FOREIGN KEY (");
        sb.mark(0);
        sb.append(") REFERENCES ");
        sb.append(info.getPkTableName());
        sb.append(" (");
        sb.mark(1);
        sb.append(")");
        for (String colName : info.getFkNameList()) {
            sb.insert(0, EMPTY, COMMA);
            sb.insert(0, colName);
        }
        for (String colName : info.getPkNameList()) {
            sb.insert(1, EMPTY, COMMA);
            sb.insert(1, colName);
        }
        return sb.toString();
    }
}

