/*
 * Decompiled with CFR 0.152.
 */
package woolpack.acquirable;

import woolpack.acquirable.Acquirable;
import woolpack.acquirable.AcquireFn;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcquirableUtils {
    public static final Acquirable ANY = new Acquirable(){

        public boolean acquire() {
            return true;
        }

        public void release() {
        }
    };
    public static final Acquirable NONE = new Acquirable(){

        public boolean acquire() {
            return false;
        }

        public void release() {
        }
    };
    public static final Acquirable INTERRUPT = new Acquirable(){

        public boolean acquire() {
            Thread.currentThread().interrupt();
            return false;
        }

        public void release() {
        }
    };
    public static final Acquirable INTERRUPTED_EXCEPTION = new Acquirable(){

        public boolean acquire() {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(new InterruptedException());
        }

        public void release() {
        }
    };

    private AcquirableUtils() {
    }

    public static <C, R, E extends Exception> AcquireFn<C, R, E> acquire(Fn<? super C, ? extends Acquirable, ? extends E> acquireGetter, Fn<? super C, ? extends R, ? extends E> trueFn, Fn<? super C, ? extends R, ? extends E> falseFn) {
        return new AcquireFn<C, R, E>(acquireGetter, trueFn, falseFn);
    }
}

