/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.typeconvert;

import junit.framework.TestCase;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;

public class DelegationIfNecessityConverterTest extends TestCase {
	private final Fn<ConvertContext, Void, RuntimeException> fn = new DelegationIfNecessityConverter(
			new Converter(FnUtils.<Object, Object>fix("piyo")));
	
	private void scenario(final Object expected, final Object before, final Class toType, final String name) {
		final ConvertContext context = new ConvertContext();
		context.setFn(fn);
		context.setToType(toType);
		context.setPropertyName(name);
		context.setValue(before);
		fn.exec(context);
		assertEquals(expected, context.getValue());
	}

	public void testNormal() {
		
		scenario(null, null, Integer.class, "hoge");
		scenario(Integer.valueOf(0), Integer.valueOf(0), null, "hoge");
		scenario(Integer.valueOf(0), Integer.valueOf(0), Integer.class, "hoge");
		scenario(Integer.valueOf(0), Integer.valueOf(0), Object.class, "hoge");
		scenario("piyo", Integer.valueOf(0), String.class, "hoge");
	}
}
