/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import woolpack.fn.Fn;

/**
 * メッセージを追加する{@link Fn}です。
 * 
 * @author nakamura
 * 
 * @param <E>
 */
public class MessageValidator<E extends Exception> implements Fn<ValidatorContext, Boolean, E> {
	private String message;

	public MessageValidator(final String message) {
		this.message = message;
	}

	public Boolean exec(final ValidatorContext context) {
		context.add(message);
		return false;
	}

	public String getMessage() {
		return message;
	}
	public void setMessage(final String message) {
		this.message = message;
	}
}
