/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.misc;

import java.util.Locale;

import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.fn.SwitchFn;

/**
 * ユーティリティです。
 * 型推論で表記を簡略するためのスタティックメソッドを含みます。
 * 
 * @author nakamura
 *
 */
public final class MiscUtils {
	private MiscUtils() {
	}
	
	public static <C, R, E extends Exception> LapTimeFn<C, R, E> lapTime(
			final Fn<? super C, ? extends R, ? extends E> fn,
			final Fn<? super Long, ?, ? extends E> reportFn) {
		return new LapTimeFn<C, R, E>(fn, reportFn);
	}
	
	public static <C, R, E extends Exception, E1 extends Exception> LoadBalancer<C, R, E, E1> loadBalancer(
			final Fn<Object, ? extends Fn<? super C, ? extends R, ? extends E>, ? extends E1> factory,
			final int length) throws Exception {
		return new LoadBalancer<C, R, E, E1>(factory, length);
	}
	
	public static <C> FnRunnable<C> fnRunnable(final Fn<? super C, ?, ? extends RuntimeException> fn, final C c) {
		return new FnRunnable<C>(fn, c);
	}
	
	public static <R> RunnableFn<R, RuntimeException> runnableFn(final Runnable runnable) {
		return new RunnableFn<R, RuntimeException>(runnable);
	}
	
	public static <C, R> SleepFn<C, R> sleep(final long sleepMillis) {
		return new SleepFn<C, R>(sleepMillis);
	}
	
	public static <R, E extends Exception> SwitchNearLocale<R, E> switchNearLocale(final SwitchFn<Locale, ? extends R, ? extends E> switching) {
		return new SwitchNearLocale<R, E>(switching);
	}
	
	public static <R> ThreadLocalGetter<R, RuntimeException> threadLocal(final ThreadLocal<? extends R> threadLocal) {
		return new ThreadLocalGetter<R, RuntimeException>(threadLocal);
	}
	
	public static <R, E extends Exception> TryLocales<R, E> tryLocales(
			final Fn<? super String, ? extends R, ? extends Exception> nodeMaker,
			final ThreadLocal<Locale> threadLocal,
			final Fn<? super Exception, ?, ? extends E> errorFn,
			final Fn<? super Exception, ? extends R, ? extends E> finalFn) {
		return new TryLocales<R, E>(nodeMaker, threadLocal, errorFn, finalFn);
	}

	public static <R> TryLocales<R, IllegalStateException> tryLocales(
			final Fn<? super String, ? extends R, ? extends Exception> nodeMaker,
			final ThreadLocal<Locale> threadLocal) {
		return MiscUtils.<R, IllegalStateException>tryLocales(
				nodeMaker,
				threadLocal,
				FnUtils.<Exception, R, IllegalStateException>fixThrows(null),
				new Fn<Exception, R, IllegalStateException>() {
					public R exec(final Exception c) throws IllegalStateException {
						throw new IllegalStateException(c);
					}
				});
	}
}
