/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.idnode;

import java.util.Map;

import woolpack.factory.FactoryUtils;
import woolpack.fn.FixFn;
import woolpack.fn.Fn;
import woolpack.id.IdContext;
import woolpack.id.IdUtils;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

/**
 * ユーティリティです。
 * 型推論で表記を簡略するためのスタティックメソッドと変数を含みます。
 * 
 * @author nakamura
 *
 */
public final class IdNodeUtils {
	private IdNodeUtils() {
	}

	/**
	 * ノードをキャッシュする{@link Fn}を返します。
	 * @param <C>
	 * @param <E>
	 * @param map キャッシュに使用するマップ。
	 * @param maker ノードを生成する委譲先。
	 * @return ノードをキャッシュする{@link Fn}。
	 */
	public static <C extends NodeContext & IdContext, E extends Exception> Fn<C, Void, E> cache(
			final Map<String, Object> map,
			final Fn<? super C, ?, ? extends E> maker) {
		return FactoryUtils.cache(
				new FixFn<C, Map<String, Object>, E>(map),
				IdUtils.<E>getId(),
				maker,
				XmlUtils.NODE_EL
		);
	}

	public static <C extends NodeContext & IdContext, E extends Exception> IFrameInserter<C, E> insertIFrame(
			final String frameId,
			final String targetName,
			final Fn<C, Void, ? extends E> nodeMaker,
			final Fn<String, String, ? extends E> idConverter) {
		return new IFrameInserter<C, E>(frameId, targetName, nodeMaker, idConverter);
	}
}
