/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import woolpack.fn.Fn;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

/**
 * テーブルの指定した列の上下同一値のセルを結合する{@link Fn}です。
 * @author nakamura
 *
 * @param <E>
 */
public class MergeCell<E extends Exception> implements Fn<NodeContext, Void, E> {
	private int colIndex;
	
	public MergeCell(final int colIndex) {
		this.colIndex = colIndex;
	}

	public Void exec(final NodeContext c) {
		Element baseCell = null;
		final NodeList trList = HtmlUtils.TR_LIST.exec(c.getNode());
		for (int i = 0; i < trList.getLength(); i++) {
			final NodeList tdList = HtmlUtils.TD_LIST.exec(trList.item(i));
			if (tdList.getLength() <= colIndex) {
				continue;
			}
			if (baseCell == null) {
				baseCell = (Element) tdList.item(colIndex);
				continue;
			}
			final Element cell = (Element) tdList.item(colIndex);
			if (XmlUtils.equalsNode(baseCell, cell)) {
				String value = baseCell.getAttribute("rowspan");
				if (value == null || value.length() == 0) {
					value = "1";
				}
				baseCell.setAttribute("rowspan", String.valueOf(Integer.parseInt(value) + 1));
				cell.getParentNode().removeChild(cell);
			} else {
				baseCell = cell;
			}
		}
		return null;
	}

	public int getColIndex() {
		return colIndex;
	}
	public void setColIndex(final int colIndex) {
		this.colIndex = colIndex;
	}
}
