/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.fn;

/**
 * 委譲先を順次実行し、最後に実行した結果を返す{@link Fn}です。
 * @author nakamura
 *
 * @param <C>
 * @param <R>
 * @param <E>
 */
public class SeqFn<C, R, E extends Exception> implements Fn<C, R, E> {
	private Iterable<? extends Fn<? super C, ? extends R, ? extends E>> iterable;

	public SeqFn(final Iterable<? extends Fn<? super C, ? extends R, ? extends E>> iterable) {
		this.iterable = iterable;
	}

	public R exec(final C c) throws E {
		R r = null;
		for (final Fn<? super C, ? extends R, ? extends E> e : iterable) {
			r = e.exec(c);
		}
		return r;
	}

	public Iterable<? extends Fn<? super C, ? extends R, ? extends E>> getIterable() {
		return iterable;
	}
	public void setIterable(final Iterable<? extends Fn<? super C, ? extends R, ? extends E>> iterable) {
		this.iterable = iterable;
	}
}
