/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.fn;


/**
 * {@link Class#cast(Object)}を使用してキャストする{@link Fn}です。
 * @author nakamura
 *
 * @param <R>
 * @param <E>
 */
public class CastFn<R, E extends Exception> implements Fn<Object, R, E> {
	private Class<R> clazz;
	
	public CastFn(final Class<R> clazz) {
		this.clazz = clazz;
	}

	public R exec(final Object c) {
		return clazz.cast(c);
	}

	public Class<R> getClazz() {
		return clazz;
	}
	public void setClazz(final Class<R> clazz) {
		this.clazz = clazz;
	}
}
