/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import java.util.Map;

import woolpack.fn.Fn;
import woolpack.typeconvert.ConvertContext;

/**
 * {@link Map}のみをサポートする{@link PropertyELFactory}です。
 * 
 * @author nakamura
 * 
 */
public class MapPropertyELFactory implements PropertyELFactory {
	private Fn<ConvertContext, Void, ? extends RuntimeException> fn;
	private PropertyELFactory factory;

	/**
	 * @param fn 変換器。
	 * @param factory 型が{@link Map}でない場合の委譲先。
	 */
	public MapPropertyELFactory(
			final Fn<ConvertContext, Void, ? extends RuntimeException> fn,
			final PropertyELFactory factory) {
		this.fn = fn;
		this.factory = factory;
	}

	public GettingEL newGetter(final Class clazz, final String propertyName) {
		if (Map.class.isAssignableFrom(clazz)) {
			return new MapEL(propertyName, fn);
		}
		return factory.newGetter(clazz, propertyName);
	}

	public EL newSetter(final Class clazz, final String propertyName) {
		if (Map.class.isAssignableFrom(clazz)) {
			return new MapEL(propertyName, fn);
		}
		return factory.newSetter(clazz, propertyName);
	}

	public Fn<ConvertContext, Void, ? extends RuntimeException> getFn() {
		return fn;
	}
	public void setFn(final Fn<ConvertContext, Void, ? extends RuntimeException> fn) {
		this.fn = fn;
	}
	public PropertyELFactory getFactory() {
		return factory;
	}
	public void setFactory(final PropertyELFactory factory) {
		this.factory = factory;
	}
}
