/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import woolpack.fn.Fn;
import woolpack.typeconvert.ConvertContext;
import woolpack.typeconvert.TypeConvertUtils;

/**
 * 式言語のユーティリティです。
 * 
 * @author nakamura
 * 
 */
public final class ELUtils {

	/**
	 * null オブジェクト役の{@link EL}です。
	 */
	public static final EL NULL = new AbstractEL() {
		@Override
		public Object getValue(final Object root, final Class toType) {
			return null;
		}

		@Override
		public void setValue(final Object root, final Object value) {
			// nothing to do.
		}
	};

	/**
	 * プロパティにアクセスする{@link GettingEL}と{@link EL}のファクトリのデフォルト値です。
	 */
	public static final PropertyELFactory PROPERTY_EL_FACTORY = getPropertyELFactory(TypeConvertUtils.COLLECTION_CONVERTER);

	private ELUtils() {
	}

	/**
	 * プロパティにアクセスする{@link GettingEL}と{@link EL}のファクトリを返します。
	 * 
	 * @param fn 型変換器。
	 * @return ファクトリ。
	 */
	public static PropertyELFactory getPropertyELFactory(final Fn<ConvertContext, Void, ? extends RuntimeException> fn) {
		return new MapPropertyELFactory(fn, new CachePropertyELFactory(
			new ReflectionPropertyELFactory(fn)));
	}
}
