/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.bool;

import woolpack.fn.Fn;

/**
 * 委譲先の一覧の呼び出し方と結果の集計方法を表します。
 * <br/>適用しているデザインパターン：Strategy。
 * @author nakamura
 *
 * @param <C> コンテキスト役。
 * @param <E> 例外。
 */
public interface BooleanOperator<C, E extends Exception> {
	/**
	 * 委譲先の一覧の呼び出し方と結果の集計方法を処理します。
	 * @param c コンテキスト役。
	 * @param iterable 委譲先の一覧。
	 * @return 集計結果。
	 * @throws E 例外。
	 */
	boolean exec(C c, Iterable<? extends Fn<? super C, Boolean, ? extends E>> iterable) throws E;
}
