/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.bool;

import woolpack.fn.Fn;

/**
 * 委譲先を順次呼び出して集計する{@link Fn}です。
 * @author nakamura
 *
 * @param <C>
 * @param <E>
 */
public class BoolSeq<C, E extends Exception> implements Fn<C, Boolean, E> {
	private BooleanOperator<C, E> operator;
	private Iterable<? extends Fn<? super C, Boolean, ? extends E>> iterable;
	
	public BoolSeq(
			final BooleanOperator<C, E> operator,
			final Iterable<? extends Fn<? super C, Boolean, ? extends E>> iterable) {
		this.operator = operator;
		this.iterable = iterable;
	}

	public Boolean exec(final C c) throws E {
		return operator.exec(c, iterable);
	}
	
	public Iterable<? extends Fn<? super C, Boolean, ? extends E>> getIterable() {
		return iterable;
	}
	public void setIterable(final Iterable<? extends Fn<? super C, Boolean, ? extends E>> iterable) {
		this.iterable = iterable;
	}
	public BooleanOperator<C, E> getOperator() {
		return operator;
	}
	public void setOperator(final BooleanOperator<C, E> operator) {
		this.operator = operator;
	}
}
