/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import woolpack.utils.BuildableArrayList;
import woolpack.utils.BuildableHashMap;
import woolpack.utils.BuildableLinkedHashMap;
import woolpack.utils.DelegationMap;
import woolpack.utils.InjectiveMap;
import woolpack.utils.InverseMap;
import woolpack.utils.KeyNotEmptyMap;
import woolpack.utils.NotNullMap;
import woolpack.utils.SimilarPropertyNameMap;
import woolpack.utils.SynchronizedConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    public static final Set<Class<?>> ATOM_SET = Collections.unmodifiableSet(new HashSet((Collection)Utils.list(Boolean.TYPE).list(Character.TYPE).list(Byte.TYPE).list(Short.TYPE).list(Integer.TYPE).list(Long.TYPE).list(Float.TYPE).list(Double.TYPE).list(Boolean.class).list(Character.class).list(Byte.class).list(Short.class).list(Integer.class).list(Long.class).list(Float.class).list(Double.class).list(BigInteger.class).list(BigDecimal.class).list(java.util.Date.class).list(Date.class).list(Time.class).list(Timestamp.class).list(String.class).list(Number.class)));

    private Utils() {
    }

    public static <K, V> Map<V, K> inverseMap(Map<K, V> before) {
        return new InverseMap<V, K>(before);
    }

    public static <K, V> Map<K, V> injectiveMap(Map<K, V> map) {
        map.getClass();
        return new InjectiveMap<K, V>(map);
    }

    public static <K, V> Map<K, V> unoverwritableMap(Map<K, V> map) {
        map.getClass();
        return new DelegationMap<K, V>((Map)map){

            private void check(K key) {
                if (super.containsKey(key)) {
                    throw new IllegalStateException("already registered:" + key);
                }
            }

            @Override
            public V put(K key, V value) {
                this.check(key);
                return super.put(key, value);
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> t) {
                for (Object key : t.keySet()) {
                    this.check(key);
                }
                super.putAll(t);
            }
        };
    }

    public static <K, V> Map<K, V> notNullMap(Map<K, V> map) {
        map.getClass();
        return new NotNullMap<K, V>(map);
    }

    public static <V> Map<String, V> keyNotEmptyMap(Map<String, V> map) {
        map.getClass();
        return new KeyNotEmptyMap<V>(map);
    }

    public static <V> Map<String, V> similarKeyMap(Map<String, V> map) {
        map.getClass();
        return new SimilarPropertyNameMap<V>(map);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(Map<K, V> map, Object lock) {
        map.getClass();
        return new SynchronizedConcurrentMap<K, V>(map, lock);
    }

    public static <E> Iterable<E> unmodifiableIterable(final Iterable<E> iterable) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Iterator it = iterable.iterator();
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public E next() {
                        return it.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static List<Object> arrayToList(final Object value) {
        return new AbstractList<Object>(){

            @Override
            public Object get(int index) {
                return Array.get(value, index);
            }

            @Override
            public int size() {
                return Array.getLength(value);
            }

            @Override
            public Object set(int index, Object after) {
                Object before = this.get(index);
                Array.set(value, index, after);
                return before;
            }
        };
    }

    public static Iterable toIterable(Object value) {
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        return Utils.toListPrivate(value);
    }

    public static Collection toCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return Utils.toListPrivate(value);
    }

    public static List toList(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        return Utils.toListPrivate(value);
    }

    private static List<Object> toListPrivate(Object value) {
        if (value != null && value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return Utils.arrayToList(value);
            }
            return Arrays.asList((Object[])value);
        }
        return Collections.singletonList(value);
    }

    public static List<String> toMessageList(Throwable throwable) {
        ArrayList<String> list = new ArrayList<String>();
        Throwable t = throwable;
        while (t != null) {
            String s = t.getLocalizedMessage();
            if (t.getCause() == null) {
                if (s != null) {
                    list.add(s);
                } else {
                    list.add(t.toString());
                }
            } else if (s != null && !t.getCause().toString().equals(s)) {
                list.add(s);
            }
            t = t.getCause();
        }
        return list;
    }

    public static <V> BuildableArrayList<V> list(V v) {
        return new BuildableArrayList<V>().list(v);
    }

    public static <V> BuildableArrayList<V> list(Collection<? extends V> c) {
        return new BuildableArrayList<V>().merge(c);
    }

    public static <K, V> BuildableHashMap<K, V> map(K key, V value) {
        return new BuildableHashMap<K, V>().map(key, value);
    }

    public static <K, V> BuildableHashMap<K, V> map(Map<? extends K, ? extends V> t) {
        return new BuildableHashMap<K, V>().merge(t);
    }

    public static <K, V> BuildableLinkedHashMap<K, V> linkedMap(K key, V value) {
        return new BuildableLinkedHashMap<K, V>().map(key, value);
    }

    public static <K, V> BuildableLinkedHashMap<K, V> linkedMap(Map<? extends K, ? extends V> t) {
        return new BuildableLinkedHashMap<K, V>().merge(t);
    }
}

