/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.util.ArrayList;
import java.util.StringTokenizer;
import woolpack.el.AbstractEL;
import woolpack.el.ArrayPathEL;
import woolpack.el.EL;
import woolpack.el.ELUtils;
import woolpack.el.PropertyEL;
import woolpack.el.PropertyELFactory;

public class PathEL
extends AbstractEL {
    private String expression;
    private PropertyELFactory factory;
    private EL el;

    public PathEL(String expression, PropertyELFactory factory) {
        this.expression = expression;
        this.factory = factory;
        this.generate();
    }

    private void generate() {
        StringTokenizer st = new StringTokenizer(this.expression, ".");
        ArrayList<PropertyEL> c = new ArrayList<PropertyEL>();
        while (st.hasMoreTokens()) {
            c.add(new PropertyEL(st.nextToken(), this.factory));
        }
        this.el = new ArrayPathEL(c);
    }

    public PathEL(String expression) {
        this(expression, ELUtils.PROPERTY_EL_FACTORY);
    }

    public Object getValue(Object root, Class clazz) {
        return this.el.getValue(root, clazz);
    }

    public void setValue(Object root, Object value) {
        this.el.setValue(root, value);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.generate();
    }

    public PropertyELFactory getFactory() {
        return this.factory;
    }

    public void setFactory(PropertyELFactory factory) {
        this.factory = factory;
        this.generate();
    }
}

