/*
 * Decompiled with CFR 0.152.
 */
package woolpack.xml;

import java.io.Reader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import woolpack.el.AbstractEL;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.fn.Fn;
import woolpack.xml.AttrRemover;
import woolpack.xml.AttrValueBranch;
import woolpack.xml.AttrValueGetter;
import woolpack.xml.AttrValueUpdater;
import woolpack.xml.ChildElementInserter;
import woolpack.xml.ChildTextReplacer;
import woolpack.xml.ChildrenRemover;
import woolpack.xml.ChildrenRetain;
import woolpack.xml.NodeClone;
import woolpack.xml.NodeContext;
import woolpack.xml.NodeFactory;
import woolpack.xml.NodeFindable;
import woolpack.xml.NodeFindableFactory;
import woolpack.xml.NodeFinder;
import woolpack.xml.NodeGetter;
import woolpack.xml.NodeNameGetter;
import woolpack.xml.NodeNormalizer;
import woolpack.xml.NodeSeeker;
import woolpack.xml.NodeSetter;
import woolpack.xml.ParentElementInserter;
import woolpack.xml.TemplateCopier;
import woolpack.xml.TextReplacer;
import woolpack.xml.ThisRemover;
import woolpack.xml.XmlTransformerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlUtils {
    public static final NodeGetter GET_NODE = new NodeGetter();
    public static final NodeNameGetter GET_NODE_NAME = new NodeNameGetter();
    public static final ThisRemover REMOVE_THIS = new ThisRemover();
    public static final ChildrenRemover REMOVE_CHILDREN = new ChildrenRemover();
    public static final ChildrenRetain RETAIN_CHILDREN = new ChildrenRetain();
    public static final NodeClone CLONE_NODE = new NodeClone();
    public static final NodeNormalizer NORMALIZE_NODE = new NodeNormalizer();
    public static final NodeFindableFactory NODE_FINDABLE_FACTORY = new NodeFindableFactory();
    public static final EL NODE_EL = new AbstractEL(){

        public Object getValue(Object root, Class clazz) {
            return ((NodeContext)root).getNode();
        }

        public void setValue(Object root, Object value) {
            ((NodeContext)root).setNode((Node)value);
        }
    };

    private XmlUtils() {
    }

    public static boolean equalsNode(Node node0, Node node1) {
        if (node0 == null) {
            return node1 == null;
        }
        if (node1 == null) {
            return false;
        }
        if (node0.getNodeType() != node1.getNodeType()) {
            return false;
        }
        if (node0.getNodeType() == 3 || node0.getNodeType() == 8) {
            return node0.getNodeValue().equals(node1.getNodeValue());
        }
        if (node0.getNodeType() == 2) {
            return node0.getNodeName().equals(node1.getNodeName()) && node0.getNodeValue().equals(node1.getNodeValue());
        }
        if (node0.getNodeType() == 9) {
            return XmlUtils.equalsNode(((Document)node0).getDocumentElement(), ((Document)node1).getDocumentElement());
        }
        if (!node0.getNodeName().equals(node1.getNodeName())) {
            return false;
        }
        Element e0 = (Element)node0;
        Element e1 = (Element)node1;
        NamedNodeMap map0 = e0.getAttributes();
        NamedNodeMap map1 = e1.getAttributes();
        if (map0.getLength() != map1.getLength()) {
            return false;
        }
        int i = 0;
        while (i < map0.getLength()) {
            if (!XmlUtils.equalsNode(map0.item(i), map1.item(i))) {
                return false;
            }
            ++i;
        }
        Node child0 = node0.getFirstChild();
        Node child1 = node1.getFirstChild();
        while (child0 != null || child1 != null) {
            if (!XmlUtils.equalsNode(child0, child1)) {
                return false;
            }
            child0 = child0.getNextSibling();
            child1 = child1.getNextSibling();
        }
        return true;
    }

    public static void removeThis(Node node) {
        node.getParentNode().removeChild(node);
    }

    public static void removeChildren(Node node) {
        Node child = null;
        while ((child = node.getFirstChild()) != null) {
            node.removeChild(child);
        }
    }

    public static void retainChildren(Node node) {
        Node parent = node.getParentNode();
        Node child = null;
        while ((child = node.getFirstChild()) != null) {
            parent.insertBefore(child, node);
        }
        parent.removeChild(node);
    }

    public static void appendText(Node node, String text) {
        node.appendChild(XmlUtils.getDocumentNode(node).createTextNode(text));
    }

    public static Document getDocumentNode(Node node) {
        return node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
    }

    public static <C extends NodeContext> AttrValueBranch<C> branchByAttrValue(Iterable<String> attrNames, Fn<String, ? extends Fn<? super C, Void>> fn) {
        return new AttrValueBranch(attrNames, fn);
    }

    public static <C extends NodeContext> NodeFinder<C> findNode(NodeFindable findable, Fn<? super C, Void> firstFn, Fn<? super C, Void> pluralFn) {
        return new NodeFinder<C>(findable, firstFn, pluralFn);
    }

    public static <C extends NodeContext> NodeFinder<C> findNode(NodeFindable findable, Fn<? super C, Void> fn) {
        return new NodeFinder<C>(findable, fn);
    }

    public static AttrValueGetter getAttrValue(String attrName) {
        return new AttrValueGetter(attrName);
    }

    public static <C extends NodeContext> ChildElementInserter<C> insertElementToChild(String elementName, Fn<? super C, Void> fn) {
        return new ChildElementInserter<C>(elementName, fn);
    }

    public static <C extends NodeContext> ChildElementInserter<C> insertElementToChild(String elementName) {
        return new ChildElementInserter(elementName);
    }

    public static <C extends NodeContext> ParentElementInserter<C> insertElementToParent(String elementName, Fn<? super C, Void> fn) {
        return new ParentElementInserter<C>(elementName, fn);
    }

    public static <C extends NodeContext> ParentElementInserter<C> insertElementToParent(String elementName) {
        return new ParentElementInserter(elementName);
    }

    public static <C extends NodeContext> TemplateCopier<C> copyTemplate(GettingEL collectionEL, EL valueEL, Fn<? super C, Void> fn) {
        return new TemplateCopier<C>(collectionEL, valueEL, fn);
    }

    public static NodeFactory nodeFactory(Fn<? super String, ? extends Reader> readerFactory, Fn<XmlTransformerContext, Void> transformer) {
        return new NodeFactory(readerFactory, transformer);
    }

    public static AttrRemover removeAttr(String attrName) {
        return new AttrRemover(attrName);
    }

    public static <C extends NodeContext> TextReplacer<C> replaceText(Fn<? super C, String> fn) {
        return new TextReplacer<C>(fn);
    }

    public static <C extends NodeContext> ChildTextReplacer<C> replaceTextToChild(Fn<? super C, String> fn) {
        return new ChildTextReplacer<C>(fn);
    }

    public static <C extends NodeContext> NodeSeeker<C> seekNode(Fn<? super C, Void> fn) {
        return new NodeSeeker<C>(fn);
    }

    public static <C extends NodeContext> NodeSetter<C> setNode(Fn<? super C, ? extends Node> fn) {
        return new NodeSetter<C>(fn);
    }

    public static <C extends NodeContext> AttrValueUpdater<C> updateAttrValue(String attrName, Fn<? super C, String> fn) {
        return new AttrValueUpdater<C>(attrName, fn);
    }
}

