/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import woolpack.utils.AbstractKeyIteratorMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapIterableMap<K, V>
extends AbstractKeyIteratorMap<K, V> {
    private Iterable<Map<K, V>> iterable;

    public MapIterableMap(Iterable<Map<K, V>> iterable) {
        this.iterable = iterable;
    }

    @Override
    protected Iterator<K> getKeyIterator() {
        HashSet set = new HashSet();
        for (Map<K, V> m : this.iterable) {
            set.addAll(m.keySet());
        }
        final Iterator it = set.iterator();
        return new Iterator<K>(){
            private K key;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public K next() {
                this.key = it.next();
                return this.key;
            }
        };
    }

    @Override
    protected V getValue(Object key) {
        for (Map<K, V> m : this.iterable) {
            V val = m.get(key);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Override
    public V get(Object key) {
        return this.getValue(key);
    }

    @Override
    public V put(K key, V val) {
        Iterator<Map<K, V>> iterator = this.iterable.iterator();
        if (iterator.hasNext()) {
            Map<K, V> m = iterator.next();
            return m.put(key, val);
        }
        return null;
    }

    public Iterable<Map<K, V>> getIterable() {
        return this.iterable;
    }

    public void setIterable(Iterable<Map<K, V>> iterable) {
        this.iterable = iterable;
    }
}

