/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import woolpack.sql.meta.ColumnInfo;
import woolpack.sql.meta.ReferenceInfo;
import woolpack.sql.meta.TableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableInfoUtils {
    private TableInfoUtils() {
    }

    public static List<TableInfo> getTableInfoList(DataSource dataSource) {
        List<TableInfo> list;
        Connection con = dataSource.getConnection();
        try {
            DatabaseMetaData metaData = con.getMetaData();
            List<TableInfo> list2 = TableInfoUtils.getTables(metaData);
            for (TableInfo tableInfo : list2) {
                TableInfoUtils.getColumns(tableInfo, metaData);
                TableInfoUtils.getPrimaryKeys(tableInfo, metaData);
                TableInfoUtils.getImportedKeys(tableInfo, metaData);
                TableInfoUtils.getExportedKeys(tableInfo, metaData);
            }
            list = list2;
        }
        catch (Throwable throwable) {
            try {
                con.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
        con.close();
        return list;
    }

    private static List<TableInfo> getTables(DatabaseMetaData metaData) throws SQLException {
        ResultSet rs = metaData.getTables(null, "%", "%", null);
        try {
            ArrayList<TableInfo> list = new ArrayList<TableInfo>();
            while (rs.next()) {
                if ("SYSTEM TABLE".equals(rs.getString("TABLE_TYPE"))) continue;
                TableInfo tableInfo = new TableInfo();
                tableInfo.setTableCatalog(rs.getString("TABLE_CAT"));
                tableInfo.setTableSchema(rs.getString("TABLE_SCHEM"));
                tableInfo.setTableName(rs.getString("TABLE_NAME"));
                list.add(tableInfo);
            }
            ArrayList<TableInfo> arrayList = list;
            return arrayList;
        }
        finally {
            rs.close();
        }
    }

    private static void getColumns(TableInfo tableInfo, DatabaseMetaData metaData) throws SQLException {
        ResultSet rs = metaData.getColumns(tableInfo.getTableCatalog(), tableInfo.getTableSchema(), tableInfo.getTableName(), "%");
        if (tableInfo.getColNameList() == null) {
            tableInfo.setColNameList(new ArrayList<String>());
        }
        if (tableInfo.getColumnInfoMap() == null) {
            tableInfo.setColumnInfoMap(new HashMap<String, ColumnInfo>());
        }
        try {
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                tableInfo.getColNameList().add(colName);
                ColumnInfo colInfo = new ColumnInfo();
                colInfo.setNotNull("NO".equals(rs.getString("IS_NULLABLE")));
                colInfo.setSize(rs.getInt("COLUMN_SIZE"));
                colInfo.setDataType(rs.getInt("DATA_TYPE"));
                colInfo.setTypeName(rs.getString("TYPE_NAME"));
                colInfo.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
                tableInfo.getColumnInfoMap().put(colName, colInfo);
            }
        }
        finally {
            rs.close();
        }
    }

    private static void getPrimaryKeys(TableInfo tableInfo, DatabaseMetaData metaData) throws SQLException {
        ResultSet rs = metaData.getPrimaryKeys(tableInfo.getTableCatalog(), tableInfo.getTableSchema(), tableInfo.getTableName());
        if (tableInfo.getPkNameList() == null) {
            tableInfo.setPkNameList(new ArrayList<String>());
        }
        try {
            while (rs.next()) {
                tableInfo.getPkNameList().add(rs.getString("COLUMN_NAME"));
            }
        }
        finally {
            rs.close();
        }
    }

    private static boolean equals(Object o0, Object o1) {
        return o0 == null ? o1 == null : o0.equals(o1);
    }

    private static void getKeys(List<ReferenceInfo> list, ResultSet rs) throws SQLException {
        while (rs.next()) {
            ReferenceInfo refInfo = new ReferenceInfo();
            refInfo.setPkTableCatalog(rs.getString("PKTABLE_CAT"));
            refInfo.setPkTableSchema(rs.getString("PKTABLE_SCHEM"));
            refInfo.setPkTableName(rs.getString("PKTABLE_NAME"));
            refInfo.setPkName(rs.getString("PK_NAME"));
            refInfo.setFkTableCatalog(rs.getString("FKTABLE_CAT"));
            refInfo.setFkTableSchema(rs.getString("FKTABLE_SCHEM"));
            refInfo.setFkTableName(rs.getString("FKTABLE_NAME"));
            refInfo.setFkName(rs.getString("FK_NAME"));
            int size = list.size();
            ReferenceInfo refInfo2 = size == 0 ? null : list.get(size - 1);
            if (refInfo2 != null && TableInfoUtils.equals(refInfo.getPkTableCatalog(), refInfo2.getPkTableCatalog()) && TableInfoUtils.equals(refInfo.getPkTableSchema(), refInfo2.getPkTableSchema()) && TableInfoUtils.equals(refInfo.getPkTableName(), refInfo2.getPkTableName()) && TableInfoUtils.equals(refInfo.getPkName(), refInfo2.getPkName()) && TableInfoUtils.equals(refInfo.getFkTableCatalog(), refInfo2.getFkTableCatalog()) && TableInfoUtils.equals(refInfo.getFkTableSchema(), refInfo2.getFkTableSchema()) && TableInfoUtils.equals(refInfo.getFkTableName(), refInfo2.getFkTableName()) && TableInfoUtils.equals(refInfo.getFkName(), refInfo2.getFkName())) {
                refInfo = refInfo2;
            } else {
                refInfo.setPkNameList(new ArrayList<String>());
                refInfo.setFkNameList(new ArrayList<String>());
                list.add(refInfo);
            }
            refInfo.getPkNameList().add(rs.getString("PKCOLUMN_NAME"));
            refInfo.getFkNameList().add(rs.getString("FKCOLUMN_NAME"));
        }
    }

    private static void getImportedKeys(TableInfo tableInfo, DatabaseMetaData metaData) throws SQLException {
        List<ReferenceInfo> list;
        ResultSet rs = metaData.getImportedKeys(tableInfo.getTableCatalog(), tableInfo.getTableSchema(), tableInfo.getTableName());
        if (tableInfo.getImportedKeysList() == null) {
            list = new ArrayList<ReferenceInfo>();
            tableInfo.setImportedKeysList(list);
        } else {
            list = tableInfo.getImportedKeysList();
        }
        try {
            TableInfoUtils.getKeys(list, rs);
        }
        finally {
            rs.close();
        }
    }

    private static void getExportedKeys(TableInfo tableInfo, DatabaseMetaData metaData) throws SQLException {
        List<ReferenceInfo> list;
        ResultSet rs = metaData.getExportedKeys(tableInfo.getTableCatalog(), tableInfo.getTableSchema(), tableInfo.getTableName());
        if (tableInfo.getExportedKeysList() == null) {
            list = new ArrayList<ReferenceInfo>();
            tableInfo.setExportedKeysList(list);
        } else {
            list = tableInfo.getExportedKeysList();
        }
        try {
            TableInfoUtils.getKeys(list, rs);
        }
        finally {
            rs.close();
        }
    }

    public static Map<String, TableInfo> convertToMap(List<TableInfo> list) {
        HashMap<String, TableInfo> map = new HashMap<String, TableInfo>(list.size());
        for (TableInfo info : list) {
            map.put(info.getTableName(), info);
        }
        return map;
    }
}

