/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import java.util.Map;
import org.w3c.dom.Node;
import woolpack.el.GettingEL;
import woolpack.fn.Fn;
import woolpack.utils.Utils;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectedValueUpdater
implements Fn<NodeContext, Void> {
    private GettingEL valueEL;
    private GettingEL mapEL;

    public SelectedValueUpdater(GettingEL valueEL, GettingEL mapEL) {
        this.valueEL = valueEL;
        this.mapEL = mapEL;
    }

    @Override
    public Void exec(NodeContext context) {
        Object value1 = this.valueEL.getValue(context);
        Iterable iterable = Utils.toIterable(value1);
        for (Object value : iterable) {
            if (value == null) continue;
            String valueString = value.toString();
            Node newNode = context.getNode().cloneNode(true);
            XmlUtils.removeChildren(newNode);
            try {
                Map map = (Map)this.mapEL.getValue(context);
                if (map.containsKey(valueString)) {
                    XmlUtils.appendText(newNode, map.get(valueString).toString());
                }
            }
            catch (NullPointerException e) {
                XmlUtils.appendText(newNode, valueString);
            }
            context.getNode().getParentNode().insertBefore(newNode, context.getNode());
        }
        XmlUtils.removeThis(context.getNode());
        return null;
    }

    public GettingEL getMapEL() {
        return this.mapEL;
    }

    public void setMapEL(GettingEL mapEL) {
        this.mapEL = mapEL;
    }

    public GettingEL getValueEL() {
        return this.valueEL;
    }

    public void setValueEL(GettingEL valueEL) {
        this.valueEL = valueEL;
    }
}

