/*
 * Decompiled with CFR 0.152.
 */
package woolpack.factory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringInputStreamFactory
implements Fn<Object, InputStream> {
    private String charset;
    private String content;

    public StringInputStreamFactory(String charset, String content) {
        this.charset = charset;
        this.content = content;
    }

    @Override
    public InputStream exec(Object c) {
        byte[] array;
        try {
            array = this.charset == null || this.charset.length() == 0 ? this.content.getBytes() : this.content.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        return new ByteArrayInputStream(array);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String s) {
        this.content = s;
    }
}

