/*
 * Decompiled with CFR 0.152.
 */
package woolpack.container;

import java.util.ArrayList;
import java.util.List;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerContext<S> {
    public static final int DEFAULT_DEPTH = 32;
    private Fn<? super ContainerContext<S>, ?> fn;
    private S subContext;
    private int depth = 32;
    private Object key;
    private int currentDepth = 0;
    private List<Object> keyList;

    public Object visit(Object key) {
        if (this.currentDepth >= this.depth) {
            throw new IllegalStateException("depth out of bounds : " + this.keyList);
        }
        if (this.keyList == null) {
            this.keyList = new ArrayList<Object>(this.depth);
        } else if (this.keyList.contains(key)) {
            throw new IllegalStateException("cyclic key : " + this.keyList);
        }
        Object baseKey = this.key;
        this.key = key;
        ++this.currentDepth;
        this.keyList.add(key);
        try {
            Object obj = this.fn.exec(this);
            return obj;
        }
        finally {
            this.key = baseKey;
            --this.currentDepth;
            this.keyList.remove(this.keyList.size() - 1);
        }
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Fn<? super ContainerContext<S>, ?> getFn() {
        return this.fn;
    }

    public void setFn(Fn<? super ContainerContext<S>, ?> fn) {
        this.fn = fn;
    }

    public S getSubContext() {
        return this.subContext;
    }

    public void setSubContext(S subContext) {
        this.subContext = subContext;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }
}

