/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.fn.FixFn;
import woolpack.fn.IfFn;
import woolpack.fn.JoinFn;
import woolpack.fn.Fn;
import woolpack.fn.SwitchFn;

public class BeanUtilsTest extends TestCase {
	public void testNormalIf() {
		final Fn<Object, Object> a = new FixFn<Object, Object>("a");
		final Fn<Object, Object> b = new FixFn<Object, Object>("b");
		final Fn<Object, Object> c = new FixFn<Object, Object>("c");
		final Fn<Object, Object> fn = new IfFn<Object, Object>(a, b, c);
		final List<PropertyDescriptor> result = BeanUtils.getConstructorGetterList(fn);
		assertEquals(3, result.size());
		assertEquals(a, BeanUtils.get(fn, result.get(0).getReadMethod()));
		assertEquals(b, BeanUtils.get(fn, result.get(1).getReadMethod()));
		assertEquals(c, BeanUtils.get(fn, result.get(2).getReadMethod()));
	}
	
	public void testNormalSwitch() {
		final Map<Integer, String> map = Utils.map(0, "key0").map(1, "key1").map(2, "key2");
		final Fn<Integer, String> defaultValue = new FixFn<Integer, String>("default0");
		final Fn<Integer, String> fn = new SwitchFn<Integer, String>(map, defaultValue);
		final List<PropertyDescriptor> result = BeanUtils.getConstructorGetterList(fn);
		assertEquals(2, result.size());
		assertEquals(map, BeanUtils.get(fn, result.get(0).getReadMethod()));
		assertEquals(defaultValue, BeanUtils.get(fn, result.get(1).getReadMethod()));
	}
	
	public void testNormalJoin() {
		final Fn<Object, Object> a = new FixFn<Object, Object>("a");
		final Fn<Object, Object> b = new FixFn<Object, Object>("b");
		final Fn<Object, Object> fn = new JoinFn<Object, Object, Object>(a, b);
		final List<PropertyDescriptor> result = BeanUtils.getConstructorGetterList(fn);
		assertEquals(2, result.size());
		assertEquals(a, BeanUtils.get(fn, result.get(0).getReadMethod()));
		assertEquals(b, BeanUtils.get(fn, result.get(1).getReadMethod()));
	}
	
	public void testNormalFix() {
		final Fn<Object, Object> a = new FixFn<Object, Object>("a");
		final List<PropertyDescriptor> result = BeanUtils.getConstructorGetterList(a);
		assertEquals(1, result.size());
		assertEquals("a", BeanUtils.get(a, result.get(0).getReadMethod()));
	}
}
