/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.idnode;

import java.io.StringReader;

import junit.framework.TestCase;
import woolpack.fn.EchoFn;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.id.IdUtils;
import woolpack.utils.Utils;
import woolpack.xml.NodeSetter;
import woolpack.xml.XmlTransformerUtils;
import woolpack.xml.XmlUtils;

public class IFrameInserterTest extends TestCase {
	public void testNormal() {
		final Fn<IdNodeContext, Void> e = IdNodeUtils.insertIFrame("frame", "target",
			new NodeSetter<IdNodeContext>(FnUtils.join(IdUtils.GET_ID,
				XmlUtils.nodeFactory(
					FnUtils.switching(
						Utils
						.map("frame", new StringReader(
							"<HTML><HEAD><TITLE>frame</TITLE></HEAD><BODY><TABLE>"
							+ "<TR><TD><IFRAME src=\"headSrc\" name=\"head\" /></TD></TR>"
							+ "<TR><TD><IFRAME src=\"menuSrc\" name=\"menu\" /></TD>"
							+ "<TD><IFRAME src=\"blankSrc\" name=\"target\" /></TD></TR>"
							+ "<TR><TD><IFRAME src=\"footSrc\" name=\"foot\" /></TD></TR>"
							+ "</TABLE></BODY></HTML>"))
						.map("headSrc", new StringReader("<HTML><HEAD><TITLE>head</TITLE></HEAD>" +
								"<BODY>bodyhead0</BODY></HTML>"))
						.map("footSrc", new StringReader("<HTML><HEAD><TITLE>foot</TITLE></HEAD>" +
								"<BODY>bodyfoot0</BODY></HTML>"))
						.map("menuSrc", new StringReader("<HTML><HEAD><TITLE>menu</TITLE></HEAD>" +
								"<BODY>bodymenu0</BODY></HTML>"))
						.map("target0", new StringReader("<HTML><HEAD><TITLE>target</TITLE></HEAD>" +
								"<BODY>bodytarget0</BODY></HTML>"))
					),
					XmlTransformerUtils.TRANSFORMER
				)
			)), new EchoFn<String>());
						
						
		final IdNodeContext context = new SimpleIdNodeContext();
		context.setId("target0");
		e.exec(context);

		assertTrue(XmlUtils.equalsNode(XmlTransformerUtils.convert(
				"<HTML><HEAD><TITLE>target</TITLE></HEAD><BODY><TABLE>"
				+ "<TR><TD>bodyhead0</TD></TR>"
				+ "<TR>"
				+ "<TD>bodymenu0</TD>"
				+ "<TD>bodytarget0</TD>"
				+ "</TR>"
				+ "<TR><TD>bodyfoot0</TD></TR>"
				+ "</TABLE></BODY></HTML>"), context.getNode()));
	}
}
