/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.idnode;

import java.io.StringReader;

import junit.framework.TestCase;
import woolpack.adapter.JXPFactory;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.id.IdUtils;
import woolpack.utils.Utils;
import woolpack.xml.NodeSetter;
import woolpack.xml.XmlTransformerUtils;
import woolpack.xml.XmlUtils;

public class FrameToTableTest extends TestCase {
	public void testNormal() {
		final Fn<IdNodeContext, Void> e = IdNodeUtils.frameToTable("frame", "target",
				new NodeSetter<IdNodeContext>(
						FnUtils.join(
								IdUtils.GET_ID,
								XmlUtils.nodeFactory(
										FnUtils.switching(
												Utils
												.map("frame", new StringReader("<HTML>"
														+ "<FRAMESET rows=\"10%,*,10%\">"
														+ "<FRAME src=\"headSrc\" name=\"head\" />"
														+ "<FRAMESET cols=\"20%,*\">"
														+ "<FRAME src=\"menuSrc\" name=\"menu\" />"
														+ "<FRAME src=\"blankSrc\" name=\"target\" />"
														+ "</FRAMESET>"
														+ "<FRAME src=\"footSrc\" name=\"foot\" />"
														+ "</FRAMESET>"
														+ "</HTML>"))
												.map("headSrc", new StringReader("<HTML><BODY>bodyhead0</BODY></HTML>"))
												.map("footSrc", new StringReader("<HTML><BODY>bodyfoot0</BODY></HTML>"))
												.map("menuSrc", new StringReader("<HTML><BODY>bodymenu0</BODY></HTML>"))
												.map("target0", new StringReader("<HTML><BODY>bodytarget0</BODY></HTML>"))
										),
										XmlTransformerUtils.TRANSFORMER
								)
						)
				), new JXPFactory());
						
						
		final IdNodeContext context = new SimpleIdNodeContext();
		context.setId("target0");
		e.exec(context);

		assertTrue(XmlUtils.equalsNode(XmlTransformerUtils.convert("<HTML><BODY><TABLE width=\"100%\">"
				+ "<TR><TD align=\"left\" valign=\"top\">bodyhead0</TD></TR>"
				+ "<TR><TD align=\"left\" valign=\"top\">"
				+ "<TABLE width=\"100%\"><TR>"
				+ "<TD width=\"20%\" align=\"left\" valign=\"top\">bodymenu0</TD>"
				+ "<TD width=\"80%\" align=\"left\" valign=\"top\">bodytarget0</TD>"
				+ "</TR></TABLE>"
				+ "</TD></TR>"
				+ "<TR><TD align=\"left\" valign=\"top\">bodyfoot0</TD></TR>"
				+ "</TABLE></BODY></HTML>"), context.getNode()));
	}
}
